/*
 * Decompiled with CFR 0.152.
 */
package com.sanitysewer.taponce;

import com.sanitysewer.taponce.MarkedSequence;
import com.sanitysewer.taponce.SequenceBuilder;
import com.sanitysewer.taponce.SoundSquare;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.Vector;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TapOnce
extends JPanel
implements MouseListener {
    SoundSquare[][] squares = new SoundSquare[12][9];
    SequenceBuilder builder;
    Sequencer sequencer = null;
    SoundSquare squareLast = null;
    Vector recorder = new Vector(1024);
    int found = 0;

    public TapOnce(int n, int n2) {
        try {
            this.sequencer = MidiSystem.getSequencer();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setLayout(new BorderLayout());
        this.setFocusable(true);
        this.builder = new SequenceBuilder(54);
        MarkedSequence[] markedSequenceArray = this.builder.getMarkedSequences();
        Vector<MarkedSequence> vector = new Vector<MarkedSequence>(markedSequenceArray.length * 2);
        int n3 = 0;
        int n4 = 0;
        while (n3 < markedSequenceArray.length * 2) {
            if (n4 == markedSequenceArray.length) {
                n4 = 0;
            }
            vector.add(markedSequenceArray[n4]);
            ++n3;
            ++n4;
        }
        Collections.shuffle(vector);
        MarkedSequence[] markedSequenceArray2 = new MarkedSequence[markedSequenceArray.length * 2];
        vector.toArray(markedSequenceArray2);
        JPanel jPanel = new JPanel(new GridLayout(9, 12));
        jPanel.setBackground(Color.black);
        int n5 = 0;
        for (int i = 0; i < 12; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.squares[i][j] = new SoundSquare(n, n2);
                this.squares[i][j].setMarkedSequence(markedSequenceArray2[n5]);
                ++n5;
                this.squares[i][j].addMouseListener(this);
                jPanel.add(this.squares[i][j]);
            }
        }
        this.add((Component)jPanel, "Center");
        this.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                block3: {
                    block4: {
                        block2: {
                            if (keyEvent.getKeyCode() != 27) break block2;
                            System.exit(0);
                            break block3;
                        }
                        if (keyEvent.getKeyCode() != 80) break block4;
                        for (int i = 0; i < TapOnce.this.recorder.size(); ++i) {
                            TapOnce.this.playMove((Sequence)TapOnce.this.recorder.get(i));
                        }
                        break block3;
                    }
                    if (keyEvent.getKeyCode() != 72) break block3;
                    for (int i = TapOnce.this.recorder.size() > 5 ? 5 : TapOnce.this.recorder.size() - 1; i >= 0; --i) {
                        TapOnce.this.playMove((Sequence)TapOnce.this.recorder.get(i));
                    }
                }
            }
        });
    }

    private void playMove(Sequence sequence) {
        try {
            this.sequencer.open();
            this.sequencer.setSequence(sequence);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.sequencer.setTempoInBPM(90.0f);
        this.sequencer.start();
        while (this.sequencer.isRunning()) {
        }
        this.sequencer.stop();
        this.sequencer.close();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof SoundSquare) {
            SoundSquare soundSquare = (SoundSquare)mouseEvent.getSource();
            MarkedSequence markedSequence = soundSquare.getMarkedSequence();
            this.playMove(markedSequence.SEQUENCE);
            this.recorder.add(markedSequence.SEQUENCE);
            if (this.squareLast == null) {
                this.squareLast = soundSquare;
            } else {
                if (soundSquare.getMarkedSequence().KEY.equals(this.squareLast.getMarkedSequence().KEY) && soundSquare != this.squareLast) {
                    soundSquare.setVisible(false);
                    this.squareLast.setVisible(false);
                    this.found += 2;
                    if (this.found == 108) {
                        for (int i = 0; i < this.recorder.size(); ++i) {
                            this.playMove((Sequence)this.recorder.get(i));
                        }
                    }
                }
                this.squareLast = null;
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        GraphicsConfiguration graphicsConfiguration = jFrame.getGraphicsConfiguration();
        int n = graphicsConfiguration.getBounds().width;
        int n2 = graphicsConfiguration.getBounds().height;
        TapOnce tapOnce = new TapOnce(n, n2);
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)tapOnce, "Center");
        container.add((Component)jPanel, "Center");
        jFrame.setUndecorated(true);
        jFrame.setSize(n, n2);
        jFrame.setLocation(new Point(0, 0));
        jFrame.setVisible(true);
        jFrame.transferFocus();
    }
}

