/*
 * Decompiled with CFR 0.152.
 */
package com.sanitysewer.taponce;

import com.sanitysewer.taponce.MarkedSequence;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public class SoundSquare
extends JComponent {
    public int w;
    public int h;
    Color[] colors = new Color[]{Color.blue, Color.black, Color.cyan, Color.darkGray, Color.green, Color.lightGray, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow};
    Color rectColor;
    Color circColor;
    MarkedSequence sequence = null;

    public SoundSquare(int n, int n2) {
        this.w = n;
        this.h = n2;
        this.rectColor = this.randomColor();
        this.circColor = this.randomColor();
        while (this.rectColor == this.circColor) {
            this.circColor = this.randomColor();
        }
    }

    public void setMarkedSequence(MarkedSequence markedSequence) {
        this.sequence = markedSequence;
    }

    public MarkedSequence getMarkedSequence() {
        return this.sequence == null ? null : this.sequence;
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.w / 12;
        graphics2D.setPaint(this.rectColor);
        graphics2D.fillRect(0, 0, n, n);
        graphics2D.setPaint(this.circColor);
        int n2 = (int)(((double)n - (double)n * 0.8) / 2.0);
        graphics2D.fillOval(n2, n2, (int)((double)n * 0.8), (int)((double)n * 0.8));
    }

    private Color randomColor() {
        Long l = new Long(Math.round(Math.random() * (double)(this.colors.length - 1)));
        int n = l.intValue();
        return this.colors[n];
    }
}

