/*
 * Decompiled with CFR 0.152.
 */
package com.sanitysewer.taponce;

import com.sanitysewer.sketch.NoiseMakers;
import com.sanitysewer.taponce.MarkedSequence;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

public class SequenceBuilder {
    final int NOTEON = 144;
    final int NOTEOFF = 128;
    final int PROGRAM = 192;
    MarkedSequence[] markedSequences;
    Sequence[] sequences;
    Track[] tracks;
    Color[] colors = new Color[]{Color.blue, Color.red, Color.green, Color.cyan, Color.magenta, Color.orange};

    public SequenceBuilder(int n) {
        this.markedSequences = new MarkedSequence[n];
        this.sequences = new Sequence[n];
        this.tracks = new Track[n];
        NoiseMakers noiseMakers = new NoiseMakers();
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>(n);
        for (int i = 0; i < n; ++i) {
            int n2;
            Sequence sequence = null;
            String string = null;
            try {
                sequence = new Sequence(0.0f, 4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Track track = sequence.createTrack();
            this.newMessage(track, 192, 9, 1, 0L);
            int n3 = (int)Math.floor(Math.random() * 6.0);
            if (n3 == 6) {
                n3 = 5;
            }
            if ((n2 = (int)Math.floor(Math.random() * 3.0)) == 3) {
                n2 = 2;
            }
            for (int j = 0; j < n2 + 1; ++j) {
                int n4;
                int n5 = noiseMakers.getInstrument(this.colors[n3], j);
                int[] nArray = this.getBeatLocation();
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    string = string + noiseMakers.getName(n5) + nArray[n4];
                    this.newMessage(track, 144, 9, n5, nArray[n4]);
                    this.newMessage(track, 128, 9, n5, nArray[n4] + 1);
                }
                if (Math.random() > 0.5) {
                    nArray = this.getBeatLocation();
                }
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    string = string + noiseMakers.getName(n5) + (nArray[n4] + 7);
                    this.newMessage(track, 144, 9, n5, nArray[n4] + 7);
                    this.newMessage(track, 128, 9, n5, nArray[n4] + 8);
                }
            }
            this.newMessage(track, 192, 9, 1, 15L);
            if (hashtable.contains(string)) {
                --i;
                continue;
            }
            hashtable.put(string, new Integer(1));
            this.markedSequences[i] = new MarkedSequence(sequence, track, string);
            this.sequences[i] = sequence;
            this.tracks[i] = track;
        }
    }

    public MarkedSequence[] getMarkedSequences() {
        return this.markedSequences;
    }

    public Sequence[] getSequences() {
        return this.sequences;
    }

    public Track[] getTracks() {
        return this.tracks;
    }

    private int[] getBeatLocation() {
        int n = (int)Math.floor(Math.random() * 8.0);
        if (n == 8) {
            n = 7;
        }
        Vector vector = new Vector(8);
        Vector<int[]> vector2 = new Vector<int[]>(8);
        vector2.add(new int[]{0, 7});
        this.getBeats(7 - n, vector, vector2);
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            Integer n2 = (Integer)vector.get(i);
            nArray[i] = n2;
        }
        return nArray;
    }

    private void getBeats(int n, Vector vector, Vector vector2) {
        if (n >= 0) {
            int n2;
            int n3 = (int)Math.floor(Math.random() * (double)vector2.size());
            if (n3 == vector2.size()) {
                --n3;
            }
            int[] nArray = (int[])vector2.get(n3);
            vector2.remove(n3);
            int n4 = nArray[0];
            int n5 = nArray[1];
            int n6 = n5 - n4;
            int n7 = (int)Math.floor(Math.random() * (double)(n6 + 1));
            if (n7 == n6 + 1) {
                --n7;
            }
            vector.add(new Integer(n7 += n4));
            --n;
            int n8 = n7 - 1;
            if (n8 - n4 >= 0) {
                vector2.add(new int[]{n4, n8});
            }
            if (n5 - (n2 = n7 + 1) >= 0) {
                vector2.add(new int[]{n2, n5});
            }
            this.getBeats(n, vector, vector2);
        }
    }

    private void newMessage(Track track, int n, int n2, int n3, long l) {
        ShortMessage shortMessage = new ShortMessage();
        try {
            shortMessage.setMessage(n, n2, n3, 100);
            MidiEvent midiEvent = new MidiEvent(shortMessage, l);
            track.add(midiEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        SequenceBuilder sequenceBuilder = new SequenceBuilder(54);
        Sequence[] sequenceArray = sequenceBuilder.getSequences();
        MarkedSequence[] markedSequenceArray = sequenceBuilder.getMarkedSequences();
        for (int i = 0; i < markedSequenceArray.length; ++i) {
            Sequencer sequencer = null;
            try {
                sequencer = MidiSystem.getSequencer();
                sequencer.open();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                sequencer.setSequence(markedSequenceArray[i].SEQUENCE);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            sequencer.setTempoInBPM(120.0f);
            sequencer.start();
            while (sequencer.isRunning()) {
            }
            sequencer.stop();
            sequencer.close();
        }
    }
}

