/*
 * Decompiled with CFR 0.152.
 */
package com.sanitysewer.gridsketch;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.swing.JComponent;

public class Scale
extends JComponent {
    public static final int PENTATONIC_C = 0;
    public static final int MICROTONAL = 1;
    int octaves;
    int w;
    int h;
    int note;
    Synthesizer synth;
    Instrument[] instruments;
    MidiChannel[] midiChannels;
    MidiChannel mc;
    int[] scale = new int[]{72, 70, 67, 65, 63, 60, 58, 55, 53, 51, 48, 46, 43, 41, 39, 36};

    public Scale(int n, int n2, int n3) {
        this.w = n2;
        this.h = n3;
        try {
            this.synth = MidiSystem.getSynthesizer();
            this.synth.open();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Soundbank soundbank = this.synth.getDefaultSoundbank();
        if (soundbank != null) {
            this.instruments = this.synth.getDefaultSoundbank().getInstruments();
            this.synth.loadInstrument(this.instruments[4]);
        }
        this.midiChannels = this.synth.getChannels();
        this.mc = this.midiChannels[1];
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = mouseEvent.getY();
                int n2 = n * 15 / Scale.this.h;
                Scale.this.note = Scale.this.scale[n2];
                Scale.this.mc.noteOn(Scale.this.scale[n2], 120);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                Scale.this.mc.noteOff(Scale.this.note);
            }
        });
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = 51;
        int n2 = this.h / 3;
        int n3 = 0;
        int n4 = this.h / 15;
        for (int i = 0; i < 3; ++i) {
            int n5 = 0;
            for (int j = 0; j < 5; ++j) {
                graphics2D.setPaint(new Color(n5, n5, n5));
                graphics2D.fillRect(0, n4 * j + n3, this.w, n4);
                n5 += n;
            }
            n3 += n2;
        }
    }

    private void play(int n) {
        this.mc.noteOn(n, 120);
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mc.noteOff(n);
    }
}

