/*
 * Decompiled with CFR 0.152.
 */
package com.sanitysewer.gridsketch;

import com.sanitysewer.gridsketch.GridSketch;
import com.sanitysewer.sketch.ScribbleSegment;
import java.util.Vector;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

public class PlayerRoll
implements Runnable {
    ScribbleSegment[] scribbles;
    Sequence sequence;
    Sequencer sequencer;
    Track track;
    GridSketch gs;
    boolean[][] grid = new boolean[32][15];
    boolean[][] grid_masks = new boolean[32][15];
    int w;
    int h;
    final int NOTEON = 144;
    final int NOTEOFF = 128;
    final int PROGRAM = 192;
    int[] scale = new int[]{72, 70, 67, 65, 63, 60, 58, 55, 53, 51, 48, 46, 43, 41, 39, 36};
    Thread t = null;
    boolean loop = false;

    public PlayerRoll(ScribbleSegment[] scribbleSegmentArray, boolean[][] blArray, int n, int n2, GridSketch gridSketch) {
        this.scribbles = scribbleSegmentArray;
        this.grid_masks = blArray;
        this.gs = gridSketch;
        this.w = n;
        this.h = n2;
        this.initGrid();
        try {
            this.sequence = new Sequence(0.0f, 4);
            this.sequencer = MidiSystem.getSequencer();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.track = this.sequence.createTrack();
        this.crunch();
    }

    private void crunch() {
        int n;
        int n2;
        int n3;
        for (n3 = 0; n3 < this.scribbles.length; ++n3) {
            Vector vector = this.scribbles[n3].getCoords();
            for (n2 = 0; n2 < vector.size(); ++n2) {
                int[] nArray = (int[])vector.get(n2);
                n = nArray[0];
                int n4 = nArray[1];
                if (n >= this.w || n4 >= this.h) continue;
                int n5 = this.w / this.grid.length;
                int n6 = (int)Math.floor((double)n / (double)n5);
                int n7 = this.h / this.grid[0].length;
                int n8 = (int)Math.floor((double)n4 / (double)n7);
                if (n6 >= this.grid.length || n8 >= this.grid[0].length || n6 < 0 || n8 < 0 || this.grid[n6][n8]) continue;
                this.grid[n6][n8] = true;
            }
        }
        this.newMessage(192, 4, 1, 0L);
        for (n3 = 0; n3 < 32; ++n3) {
            for (int i = 0; i < 15; ++i) {
                if (!this.grid[n3][i]) continue;
                n2 = n3 + 1;
                if (this.grid_masks[n3][i]) {
                    int n9 = 1;
                    for (n = n3 + 1; n < 32 && this.grid_masks[n][i]; ++n) {
                        ++n9;
                        this.grid[n + 1][i] = false;
                    }
                    n2 += n9;
                    this.grid[n3 + 1][i] = false;
                }
                this.newMessage(144, 4, this.scale[i], n3);
                this.newMessage(128, 4, this.scale[i], n2);
            }
        }
        this.newMessage(192, 4, 1, 15L);
    }

    public boolean isLooping() {
        return this.loop;
    }

    public void switchLooping() {
        this.loop = !this.loop;
    }

    public void play(boolean bl) {
        this.loop = bl;
        this.play();
    }

    public void play() {
        this.t = new Thread(this);
        this.t.start();
    }

    public void run() {
        if (!this.sequencer.isOpen()) {
            try {
                this.sequencer.open();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            this.sequencer.setSequence(this.sequence);
            this.sequencer.setTempoInBPM(90.0f);
            this.sequencer.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        while (this.sequencer.isRunning()) {
        }
        while (this.loop) {
            this.updateMeasure(this.gs.getScribbleSegments(), this.gs.getGridMasks());
            this.run();
        }
        if (this.sequencer.isOpen()) {
            this.sequencer.stop();
        }
        this.sequencer.close();
    }

    public void updateMeasure(ScribbleSegment[] scribbleSegmentArray, boolean[][] blArray) {
        this.scribbles = scribbleSegmentArray;
        this.grid_masks = blArray;
        this.initGrid();
        if (this.sequence.deleteTrack(this.track)) {
            this.track = this.sequence.createTrack();
        }
        this.crunch();
    }

    private void initGrid() {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 15; ++j) {
                this.grid[i][j] = false;
            }
        }
    }

    private void newMessage(int n, int n2, int n3, long l) {
        ShortMessage shortMessage = new ShortMessage();
        try {
            shortMessage.setMessage(n, n2, n3, 100);
            MidiEvent midiEvent = new MidiEvent(shortMessage, l);
            this.track.add(midiEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

