/*
 * Decompiled with CFR 0.152.
 */
package com.sanitysewer.gridsketch;

import com.sanitysewer.common.QuiltBoardMappings;
import com.sanitysewer.gridsketch.DrawingArea;
import com.sanitysewer.gridsketch.PlayerRoll;
import com.sanitysewer.gridsketch.Scale;
import com.sanitysewer.sketch.ScribbleSegment;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class GridSketch
extends JPanel {
    Color bkgrnd = Color.white;
    int w;
    int h;
    DrawingArea da;
    PlayerRoll roll = null;
    QuiltBoardMappings quilt = new QuiltBoardMappings();
    int grid_width;
    int keyboard_width;
    GridSketch gs;
    static /* synthetic */ Class class$com$sanitysewer$gridsketch$GridSketch;

    public GridSketch(int n, int n2) {
        this.setFocusable(true);
        this.setBackground(this.bkgrnd);
        this.setLayout(new BorderLayout());
        this.gs = this;
        this.w = n;
        this.h = n2;
        this.grid_width = this.getGridWidth(this.w, 0.9);
        this.keyboard_width = this.w - this.grid_width;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.black);
        jPanel.setPreferredSize(new Dimension(this.keyboard_width, this.h));
        jPanel.add((Component)new Scale(0, this.keyboard_width, this.h), "Center");
        this.da = new DrawingArea((int)((double)this.w * 0.9), this.h);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBackground(Color.magenta);
        jPanel2.add(this.da);
        jPanel2.setPreferredSize(new Dimension(this.grid_width, this.h));
        this.add((Component)jPanel, "West");
        this.add((Component)jPanel2, "East");
        this.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    System.exit(0);
                } else if (GridSketch.this.quilt.isActiveQuiltKey(keyEvent.getKeyCode())) {
                    String string = GridSketch.this.quilt.getQuiltKeyName(keyEvent.getKeyCode());
                    if (string == "blank") {
                        GridSketch.this.roll = null;
                        GridSketch.this.da.clear();
                    } else if (string == "o") {
                        if (GridSketch.this.roll != null) {
                            if (GridSketch.this.roll.isLooping()) {
                                GridSketch.this.roll.switchLooping();
                            } else {
                                GridSketch.this.roll.play(true);
                            }
                        } else {
                            GridSketch.this.roll = new PlayerRoll(GridSketch.this.da.getScribbleSegments(), GridSketch.this.da.getGridMasks(), GridSketch.this.grid_width, GridSketch.this.h, GridSketch.this.gs);
                            GridSketch.this.roll.play(true);
                        }
                    } else if (string == "-") {
                        GridSketch.this.da.removeActiveScribble();
                    } else if (string == "duck") {
                        GridSketch.this.roll = new PlayerRoll(GridSketch.this.da.getScribbleSegments(), GridSketch.this.da.getGridMasks(), GridSketch.this.grid_width, GridSketch.this.h, GridSketch.this.gs);
                        GridSketch.this.roll.play();
                    }
                }
            }
        });
    }

    public ScribbleSegment[] getScribbleSegments() {
        return this.da.getScribbleSegments();
    }

    public boolean[][] getGridMasks() {
        return this.da.getGridMasks();
    }

    private int getGridWidth(int n, double d) {
        n = (int)((double)n * d);
        while (n % 32 != 0) {
            --n;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        GraphicsConfiguration graphicsConfiguration = jFrame.getGraphicsConfiguration();
        int n = graphicsConfiguration.getBounds().width;
        int n2 = graphicsConfiguration.getBounds().height;
        GridSketch gridSketch = new GridSketch(n, n2);
        jFrame.transferFocus();
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(gridSketch);
        container.add((Component)jPanel, "Center");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        URL uRL = (class$com$sanitysewer$gridsketch$GridSketch == null ? (class$com$sanitysewer$gridsketch$GridSketch = GridSketch.class$("com.sanitysewer.gridsketch.GridSketch")) : class$com$sanitysewer$gridsketch$GridSketch).getResource("black_left_cursor.png");
        Image image = toolkit.getImage(uRL);
        jFrame.setCursor(toolkit.createCustomCursor(image, new Point(1, 1), "big_black_left"));
        jFrame.setUndecorated(true);
        jFrame.setSize(n, n2);
        jFrame.setLocation(new Point(0, 0));
        jFrame.setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

