/*
 * Decompiled with CFR 0.152.
 */
package com.sanitysewer.gridsketch;

import com.sanitysewer.common.GeometryChecker;
import com.sanitysewer.common.Interpolater;
import com.sanitysewer.sketch.ScribbleSegment;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JComponent;

public class DrawingArea
extends JComponent {
    int count = 0;
    int w;
    int h;
    BufferedImage bi;
    Graphics2D g2;
    int oldX;
    int oldY;
    int currentX;
    int currentY;
    Vector segments = new Vector(18);
    ScribbleSegment scribble;
    GeometryChecker geomch = new GeometryChecker();
    Interpolater intpol = new Interpolater();
    int active_scribble = -1;
    boolean refresh_background = true;
    boolean[][] grid_masks;
    Vector mask_list = new Vector(480);
    boolean drag_mode = false;
    boolean just_dragged = false;

    public DrawingArea(int n, int n2) {
        this.w = n;
        this.h = n2;
        this.grid_masks = new boolean[32][15];
        for (int i = 0; i < this.grid_masks.length; ++i) {
            for (int j = 0; j < this.grid_masks[i].length; ++j) {
                this.grid_masks[i][j] = false;
            }
        }
        this.bi = new BufferedImage(this.w, this.h, 5);
        this.g2 = this.bi.createGraphics();
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                DrawingArea.this.oldX = mouseEvent.getX();
                DrawingArea.this.oldY = mouseEvent.getY();
                if (DrawingArea.this.active_scribble > -1) {
                    ScribbleSegment scribbleSegment = (ScribbleSegment)DrawingArea.this.segments.get(DrawingArea.this.active_scribble);
                    Vector vector = scribbleSegment.getCoords();
                    DrawingArea.this.drag_mode = DrawingArea.this.geomch.isPointNearLine(vector, DrawingArea.this.oldX, DrawingArea.this.oldY, 7);
                }
                if (!DrawingArea.this.drag_mode) {
                    DrawingArea.this.just_dragged = false;
                    DrawingArea.this.scribble = new ScribbleSegment();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (DrawingArea.this.scribble.size() > 1) {
                    DrawingArea.this.segments.add(DrawingArea.this.scribble);
                } else {
                    Object object;
                    int n = mouseEvent.getX();
                    int n2 = mouseEvent.getY();
                    boolean bl = false;
                    for (int i = 0; i < DrawingArea.this.segments.size(); ++i) {
                        ScribbleSegment scribbleSegment = (ScribbleSegment)DrawingArea.this.segments.get(i);
                        object = scribbleSegment.getCoords();
                        if (!DrawingArea.this.geomch.isPointNearLine((Vector)object, n, n2, 7)) continue;
                        bl = true;
                        if (DrawingArea.this.active_scribble == -1 || i != DrawingArea.this.active_scribble) {
                            DrawingArea.this.active_scribble = i;
                            DrawingArea.this.drag_mode = true;
                            DrawingArea.this.refresh_background = false;
                            DrawingArea.this.composeBackground();
                            DrawingArea.this.redrawScribbles(i, true);
                            DrawingArea.this.repaint();
                            break;
                        }
                        if (!DrawingArea.this.just_dragged) {
                            DrawingArea.this.active_scribble = -1;
                            DrawingArea.this.drag_mode = false;
                            DrawingArea.this.refresh_background = false;
                            DrawingArea.this.composeBackground();
                            DrawingArea.this.redrawScribbles(-1, false);
                            DrawingArea.this.repaint();
                            break;
                        }
                        DrawingArea.this.just_dragged = false;
                        break;
                    }
                    if (DrawingArea.this.isOnXBoundry(n, 10) && !bl) {
                        int[] nArray = DrawingArea.this.getGridLocation(n, n2);
                        if (!DrawingArea.this.grid_masks[nArray[0]][nArray[1]]) {
                            DrawingArea.this.grid_masks[nArray[0]][nArray[1]] = true;
                            DrawingArea.this.mask_list.add(nArray);
                        } else {
                            DrawingArea.this.grid_masks[nArray[0]][nArray[1]] = false;
                            for (int i = 0; i < DrawingArea.this.mask_list.size(); ++i) {
                                object = (int[])DrawingArea.this.mask_list.get(i);
                                if (object[0] != nArray[0] || object[1] != nArray[1]) continue;
                                DrawingArea.this.mask_list.remove(i);
                            }
                        }
                        DrawingArea.this.refresh_background = false;
                        DrawingArea.this.composeBackground();
                        DrawingArea.this.redrawScribbles(DrawingArea.this.active_scribble, true);
                        DrawingArea.this.repaint();
                    } else if (!bl) {
                        DrawingArea.this.refresh_background = false;
                        DrawingArea.this.composeBackground();
                        DrawingArea.this.redrawScribbles(DrawingArea.this.active_scribble, false);
                        DrawingArea.this.repaint();
                        DrawingArea.this.active_scribble = -1;
                    }
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                DrawingArea.this.currentX = mouseEvent.getX();
                DrawingArea.this.currentY = mouseEvent.getY();
                if (!DrawingArea.this.drag_mode) {
                    DrawingArea.this.just_dragged = false;
                    if (Math.abs(DrawingArea.this.oldX - DrawingArea.this.currentX) > 15 || Math.abs(DrawingArea.this.oldY - DrawingArea.this.currentY) > 15) {
                        Vector vector = DrawingArea.this.intpol.interpolateLinearlyToThreshold(new Vector(), DrawingArea.this.oldX, DrawingArea.this.oldY, DrawingArea.this.currentX, DrawingArea.this.currentY, 15);
                        int n = DrawingArea.this.oldX;
                        int n2 = DrawingArea.this.oldY;
                        for (int i = 0; i < vector.size(); ++i) {
                            int[] nArray = (int[])vector.get(i);
                            DrawingArea.this.scribble.addCoordinate(nArray[0], nArray[1], Color.black);
                            if (DrawingArea.this.g2 != null) {
                                DrawingArea.this.g2.drawLine(n, n2, nArray[0], nArray[1]);
                            }
                            n = nArray[0];
                            n2 = nArray[1];
                        }
                    } else {
                        DrawingArea.this.scribble.addCoordinate(DrawingArea.this.currentX, DrawingArea.this.currentY, Color.black);
                        if (DrawingArea.this.g2 != null) {
                            DrawingArea.this.g2.drawLine(DrawingArea.this.oldX, DrawingArea.this.oldY, DrawingArea.this.currentX, DrawingArea.this.currentY);
                        }
                    }
                } else if (DrawingArea.this.drag_mode && DrawingArea.this.active_scribble > -1) {
                    DrawingArea.this.just_dragged = true;
                    int n = DrawingArea.this.currentX - DrawingArea.this.oldX;
                    int n3 = DrawingArea.this.currentY - DrawingArea.this.oldY;
                    ScribbleSegment scribbleSegment = (ScribbleSegment)DrawingArea.this.segments.get(DrawingArea.this.active_scribble);
                    scribbleSegment.updateCoords(n, n3);
                    DrawingArea.this.refresh_background = false;
                    DrawingArea.this.composeBackground();
                    DrawingArea.this.redrawScribbles(DrawingArea.this.active_scribble, true);
                }
                DrawingArea.this.oldX = DrawingArea.this.currentX;
                DrawingArea.this.oldY = DrawingArea.this.currentY;
                DrawingArea.this.repaint();
            }
        });
    }

    public boolean[][] getGridMasks() {
        return this.grid_masks;
    }

    public ScribbleSegment[] getScribbleSegments() {
        ScribbleSegment[] scribbleSegmentArray = new ScribbleSegment[this.segments.size()];
        return this.segments.toArray(scribbleSegmentArray);
    }

    public void removeActiveScribble() {
        if (this.active_scribble != -1) {
            this.segments.remove(this.active_scribble);
            this.active_scribble = -1;
            this.drag_mode = false;
            this.refresh_background = false;
            this.composeBackground();
            this.redrawScribbles(this.active_scribble, false);
            this.repaint();
        }
    }

    public int[] getGridLocation(int n, int n2) {
        int n3 = this.w / this.grid_masks.length;
        int n4 = (int)Math.round((double)n / (double)n3) - 1;
        int n5 = this.h / this.grid_masks[0].length;
        int n6 = (int)Math.floor((double)n2 / (double)n5);
        if (n4 < 0) {
            n4 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        int[] nArray = new int[]{n4, n6};
        return nArray;
    }

    public boolean isOnXBoundry(int n, int n2) {
        int n3 = this.w / this.grid_masks.length;
        int n4 = (int)Math.round((double)n / (double)n3);
        int n5 = n4 * n3;
        return n <= n5 + n2 / 2 && n >= n5 - n2 / 2;
    }

    public void redrawScribbles(int n, boolean bl) {
        for (int i = 0; i < this.segments.size(); ++i) {
            ScribbleSegment scribbleSegment = (ScribbleSegment)this.segments.get(i);
            Vector vector = scribbleSegment.getCoords();
            BasicStroke basicStroke = (BasicStroke)this.g2.getStroke();
            if (i == n && bl) {
                this.g2.setStroke(new BasicStroke(basicStroke.getLineWidth() * 3.25f));
            }
            for (int j = 0; j < vector.size(); ++j) {
                int[] nArray = (int[])vector.get(j);
                if (j + 1 >= vector.size()) continue;
                int[] nArray2 = (int[])vector.get(j + 1);
                this.g2.drawLine(nArray[0], nArray[1], nArray2[0], nArray2[1]);
            }
            this.g2.setStroke(basicStroke);
        }
    }

    public void paintComponent(Graphics graphics) {
        if (this.refresh_background) {
            this.composeBackground();
            this.refresh_background = false;
        }
        graphics.drawImage(this.bi, 0, 0, null);
    }

    public void composeBackground() {
        int n;
        int n2;
        int n3;
        int n4;
        this.g2.setPaint(Color.white);
        this.g2.fillRect(0, 0, this.w, this.h);
        int n5 = (int)((double)this.w / 32.0);
        this.g2.setPaint(new Color(215, 215, 215));
        for (n4 = 1; n4 < 32; ++n4) {
            n3 = 6;
            n2 = 0;
            n = 0;
            while (n2 < this.h) {
                if (n % 2 == 0) {
                    this.g2.drawLine(n4 * n5, n2, n4 * n5, n2 + n3);
                }
                n2 += n3;
                ++n;
            }
        }
        n5 = (int)((double)this.h / 15.0);
        this.g2.setPaint(new Color(215, 215, 215));
        for (n4 = 1; n4 < 15; ++n4) {
            n3 = 6;
            n2 = 0;
            n = 0;
            while (n2 < this.w) {
                if (n % 2 == 0) {
                    this.g2.drawLine(n2, n4 * n5, n2 + n3, n4 * n5);
                }
                n2 += n3;
                ++n;
            }
        }
        this.g2.setPaint(Color.white);
        for (n4 = 0; n4 < this.mask_list.size(); ++n4) {
            int[] nArray = (int[])this.mask_list.get(n4);
            n2 = this.w / this.grid_masks.length;
            n = this.h / this.grid_masks[0].length;
            int n6 = nArray[0] * n2 + n2 - 2;
            int n7 = nArray[1] * n;
            this.g2.fillRect(n6, n7, 4, n);
        }
        this.g2.setPaint(Color.black);
    }

    private void resetGridMasks() {
        for (int i = 0; i < this.grid_masks.length; ++i) {
            for (int j = 0; j < this.grid_masks[0].length; ++j) {
                this.grid_masks[i][j] = false;
            }
        }
    }

    public void clear() {
        this.segments.removeAllElements();
        this.mask_list.removeAllElements();
        this.active_scribble = -1;
        this.resetGridMasks();
        this.drag_mode = false;
        this.refresh_background = true;
        this.repaint();
    }
}

