/*
 * Decompiled with CFR 0.152.
 */
package com.sanitysewer.common;

import java.util.Vector;

public class GeometryChecker {
    public static final int RIGHT = 0;
    public static final int LEFT = 1;
    public static final int LEFT_OR_RIGHT = -1;

    public boolean isPointNearLine(Vector vector, int n, int n2, int n3) {
        if (!this.isPointInBoundingBox(vector, n, n2, n3)) {
            return false;
        }
        for (int i = 0; i < vector.size() - 1; ++i) {
            double d;
            double[] dArray;
            double[] dArray2 = new double[2];
            double[] dArray3 = new double[2];
            int[] nArray = (int[])vector.get(i);
            int[] nArray2 = i + 1 < vector.size() ? (int[])vector.get(i + 1) : (int[])vector.get(i);
            double[] dArray4 = this.int_to_double(nArray);
            if (dArray4[0] != (dArray = this.int_to_double(nArray2))[0]) {
                double d2;
                if (dArray4[1] != dArray[1]) {
                    d2 = this.getSlope(dArray4, dArray);
                    double d3 = this.getRangeIntersection(d2, dArray[0], dArray[1]);
                    double d4 = -1.0 * (1.0 / d2);
                    double[] dArray5 = this.extrapolate(d4, n3, n, n2);
                    dArray2[0] = dArray5[0];
                    dArray2[1] = dArray5[1];
                    dArray3[0] = dArray5[2];
                    dArray3[1] = dArray5[3];
                    double d5 = this.getRangeIntersection(d4, n, n2);
                    d = this.getIntersection(d5, d3, d4, d2);
                    if (!this.pointLiesOnLine(d, dArray2[0], dArray3[0], dArray4[0], dArray[0])) continue;
                    return true;
                }
                dArray2[0] = n;
                dArray2[1] = n2 - n3;
                dArray3[0] = n;
                dArray3[1] = n2 + n3;
                d = n;
                d2 = dArray4[1];
                if (!this.pointLiesOnLine(d, dArray2[0], dArray3[0], dArray4[0], dArray[0]) || !this.pointLiesOnLine(d2, dArray2[1], dArray3[1], dArray4[1], dArray[1])) continue;
                return true;
            }
            dArray2[0] = n - n3;
            dArray2[1] = n2;
            dArray3[0] = n + n3;
            dArray3[1] = n2;
            d = dArray4[0];
            if (!this.pointLiesOnLine(d, dArray2[0], dArray3[0], dArray4[0], dArray[0])) continue;
            return true;
        }
        return false;
    }

    private double[] int_to_double(int[] nArray) {
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = nArray[i];
        }
        return dArray;
    }

    private boolean pointLiesOnLine(double d, double d2, double d3, double d4, double d5) {
        if (d2 >= d3 && d4 <= d5) {
            double d6 = d2;
            d2 = d3;
            d3 = d6;
        } else if (d2 <= d3 && d4 >= d5) {
            double d7 = d4;
            d4 = d5;
            d5 = d7;
        } else if (d2 >= d3 && d4 >= d5) {
            double d8 = d2;
            d2 = d3;
            d3 = d8;
            d8 = d4;
            d4 = d5;
            d5 = d8;
        }
        return d >= d2 && d <= d3 && d >= d4 && d <= d5;
    }

    private double getRangeIntersection(double d, double d2, double d3) {
        return d3 - d2 * d;
    }

    private double[] extrapolate(double d, double d2, double d3, double d4) {
        double d5 = Math.atan(1.0 / d);
        double d6 = Math.sin(d5) * d2;
        double d7 = Math.cos(d5) * d2;
        double[] dArray = new double[]{d3 + d6 * -1.0, d4 + d7 * -1.0, d3 + d6, d4 + d7};
        return dArray;
    }

    public boolean isPointInBoundingBox(Vector vector, int n, int n2, int n3) {
        int[] nArray = this.getBoundingBox(vector);
        int n4 = nArray[1];
        int n5 = nArray[0];
        int n6 = nArray[3];
        int n7 = nArray[2];
        return n < n4 + n3 && n > n5 - n3 && n2 < n6 + n3 && n2 > n7 - n3;
    }

    public boolean areEnclosedBoxes(Vector vector, Vector vector2) {
        int[] nArray;
        int[] nArray2 = this.getBoundingBox(vector);
        if ((nArray2[0] <= (nArray = this.getBoundingBox(vector2))[0] && nArray2[1] >= nArray[1] || nArray[0] <= nArray2[0] && nArray[1] >= nArray2[1]) && (nArray2[2] >= nArray[2] && nArray2[3] <= nArray[3] || nArray[2] >= nArray2[2] && nArray[3] <= nArray2[3])) {
            return true;
        }
        if ((nArray2[2] <= nArray[2] && nArray2[3] >= nArray[3] || nArray[2] <= nArray2[2] && nArray[3] >= nArray2[3]) && (nArray2[0] >= nArray[0] && nArray2[1] <= nArray[1] || nArray[0] >= nArray2[0] && nArray[1] <= nArray2[1])) {
            return true;
        }
        return nArray[0] >= nArray2[0] && nArray[1] <= nArray2[1] && nArray[2] >= nArray2[2] && nArray[3] <= nArray2[3] || nArray2[0] >= nArray[0] && nArray2[1] <= nArray[1] && nArray2[2] >= nArray[2] && nArray2[3] <= nArray[3];
    }

    public boolean areIntersectingBoxes(Vector vector, Vector vector2, int n) {
        int n2 = -1;
        int n3 = -1;
        if (n == 1) {
            n2 = 1;
            n3 = 0;
        } else if (n == 0) {
            n2 = 0;
            n3 = 1;
        }
        int[] nArray = this.getBoundingBox(vector);
        int[] nArray2 = this.getBoundingBox(vector2);
        return n2 == 0 || n2 == 1 ? nArray2[n2] >= nArray[0] && nArray2[n2] <= nArray[1] && (nArray2[2] >= nArray[2] && nArray2[2] <= nArray[3] || nArray2[3] >= nArray[2] && nArray2[3] <= nArray[3] || nArray2[2] <= nArray[2] && nArray2[3] >= nArray[3] || nArray2[2] <= nArray[2] && nArray2[3] >= nArray[3]) : (nArray2[0] >= nArray[0] && nArray2[0] <= nArray[1] || nArray2[1] >= nArray[0] && nArray2[1] <= nArray[1] || nArray2[0] <= nArray[0] && nArray2[1] >= nArray[1] || nArray[0] <= nArray2[0] && nArray[1] >= nArray2[1]) && (nArray2[2] >= nArray[2] && nArray2[2] <= nArray[3] || nArray2[3] >= nArray[2] && nArray2[3] <= nArray[3] || nArray2[2] <= nArray[2] && nArray2[3] >= nArray[3]);
    }

    public boolean doLinesCross(Vector vector, Vector vector2) {
        block0: for (int i = 0; i < vector.size(); ++i) {
            int[] nArray;
            Vector<int[]> vector3 = new Vector<int[]>(2);
            Vector<int[]> vector4 = new Vector<int[]>(2);
            int[] nArray2 = (int[])vector.get(i);
            if (i + 1 >= vector.size()) {
                nArray = nArray2;
                break;
            }
            nArray = (int[])vector.get(i + 1);
            vector4.add(nArray2);
            vector4.add(nArray);
            for (int j = 0; j < vector2.size(); ++j) {
                double d;
                int[] nArray3;
                int[] nArray4 = (int[])vector2.get(j);
                if (j + 1 >= vector2.size()) {
                    nArray3 = nArray4;
                    continue block0;
                }
                nArray3 = (int[])vector2.get(j + 1);
                vector3.add(nArray4);
                vector3.add(nArray3);
                if (!this.areIntersectingBoxes(vector3, vector4, -1)) continue;
                if (nArray2[0] == nArray[0] && nArray2[1] != nArray[1] || nArray4[0] == nArray3[0] && nArray4[1] != nArray3[1]) {
                    d = nArray2[0] == nArray[0] ? (double)nArray2[0] : (double)nArray3[0];
                    if (!this.pointLiesOnLine(d, nArray2[0], nArray[0], nArray4[0], nArray3[0])) continue;
                    return true;
                }
                double d2 = this.getSlope(nArray2, nArray);
                double d3 = this.getSlope(nArray4, nArray3);
                double d4 = this.getRangeIntersection(d2, nArray2[0], nArray2[1]);
                double d5 = this.getRangeIntersection(d3, nArray4[0], nArray4[1]);
                d = this.getIntersection(d4, d5, d2, d3);
                if (d2 == d3 || !this.pointLiesOnLine(d, nArray2[0], nArray[0], nArray4[0], nArray3[0])) continue;
                return true;
            }
        }
        return false;
    }

    private double getIntersection(double d, double d2, double d3, double d4) {
        double d5 = (d - d2) / (d4 - d3);
        return d5;
    }

    private double getSlope(int[] nArray, int[] nArray2) {
        double[] dArray = new double[]{nArray[0], nArray[1]};
        double[] dArray2 = new double[]{nArray2[0], nArray2[1]};
        return this.getSlope(dArray, dArray2);
    }

    private double getSlope(double[] dArray, double[] dArray2) {
        double d = (dArray[1] - dArray2[1]) / (dArray[0] - dArray2[0]);
        return d;
    }

    public int[] getBoundingBox(Vector vector) {
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MAX_VALUE;
        for (int i = 0; i < vector.size(); ++i) {
            int[] nArray = (int[])vector.get(i);
            if (nArray[0] > n) {
                n = nArray[0];
            }
            if (nArray[0] < n2) {
                n2 = nArray[0];
            }
            if (nArray[1] > n3) {
                n3 = nArray[1];
            }
            if (nArray[1] >= n4) continue;
            n4 = nArray[1];
        }
        int[] nArray = new int[]{n2, n, n4, n3};
        return nArray;
    }

    public static void main(String[] stringArray) {
        GeometryChecker geometryChecker = new GeometryChecker();
        Vector<int[]> vector = new Vector<int[]>(2);
        int[] nArray = new int[]{2, 2};
        int[] nArray2 = new int[]{2, 8};
        vector.add(nArray);
        vector.add(nArray2);
        Vector<int[]> vector2 = new Vector<int[]>(2);
        int[] nArray3 = new int[]{4, 4};
        int[] nArray4 = new int[]{6, 6};
        vector2.add(nArray3);
        vector2.add(nArray4);
        System.out.println("P: " + (geometryChecker.isPointNearLine(vector, 8, 4, 3) ? "true" : "false"));
    }
}

