/*
 * Decompiled with CFR 0.152.
 */
package com.sanitysewer.sketch;

import com.sanitysewer.sketch.DrawPad;
import com.sanitysewer.sketch.NoiseMakers;
import com.sanitysewer.sketch.ScribbleSegment;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

public class OrganGrinder
implements Runnable {
    int[][] coords;
    Hashtable timbre;
    Vector scribbles;
    NoiseMakers noises;
    Sequencer sequencer;
    Sequence sequence = null;
    Track track;
    int avgLength = 0;
    int offset = 0;
    boolean up = false;
    int current = 0;
    boolean loop = false;
    Vector play_order = new Vector(18);
    Thread t;
    boolean replay = false;
    DrawPad dp = null;
    final int velocity = 100;
    final int NOTEON = 144;
    final int NOTEOFF = 128;
    final int PROGRAM = 192;

    public OrganGrinder(Vector vector, Vector vector2, DrawPad drawPad) {
        this.scribbles = vector;
        this.dp = drawPad;
        this.noises = new NoiseMakers();
        try {
            this.sequence = new Sequence(0.0f, 4);
            this.sequencer = MidiSystem.getSequencer();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.track = this.sequence.createTrack();
    }

    public void updateSegments(Vector vector) {
        this.clear();
        this.scribbles = vector;
    }

    public void updateSegments(Vector vector, Vector vector2) {
        this.clear();
        this.scribbles = vector;
        this.play_order = vector2;
    }

    public void updatePlayOrder(Vector vector) {
        this.clear();
        this.play_order = vector;
    }

    public void clear() {
        this.current = 0;
        this.offset = 0;
        this.avgLength = 0;
        this.sequence.deleteTrack(this.track);
        this.track = this.sequence.createTrack();
    }

    public void crunch() {
        for (int i = 0; i < this.scribbles.size(); ++i) {
            ScribbleSegment scribbleSegment = (ScribbleSegment)this.scribbles.get(i);
            this.avgLength += scribbleSegment.size();
        }
        if (this.scribbles.size() > 0) {
            this.avgLength /= this.scribbles.size();
        }
        ScribbleSegment scribbleSegment = null;
        for (int i = 0; i < this.play_order.size(); ++i) {
            Vector vector = (Vector)this.play_order.get(i);
            for (int j = 0; j < vector.size(); ++j) {
                Integer n = (Integer)vector.get(j);
                int n2 = n;
                scribbleSegment = (ScribbleSegment)this.scribbles.get(n2);
                Vector vector2 = scribbleSegment.getCoords();
                this.coords = new int[vector2.size()][2];
                vector2.toArray((T[])this.coords);
                this.timbre = scribbleSegment.getTimbres();
                this.findDirectionChange();
            }
            this.offset += this.updateOffset(scribbleSegment.size());
            ++this.current;
        }
    }

    public void switchLooping() {
        this.loop = !this.loop;
    }

    public void run() {
        if (!this.replay) {
            this.crunch();
            this.replay = true;
        }
        if (!this.sequencer.isOpen()) {
            try {
                this.sequencer.open();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            this.sequencer.setSequence(this.sequence);
            this.sequencer.setTempoInBPM(90.0f);
            this.sequencer.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        while (this.sequencer.isRunning()) {
        }
        if (this.loop) {
            if (this.dp.hasChange()) {
                this.dp.setChange(false);
                Vector vector = this.dp.getSegments();
                this.dp.updatePlayOrder(vector);
                Vector vector2 = this.dp.getPlayOrder();
                this.updateSegments(vector, vector2);
                this.crunch();
            }
            this.run();
        }
        if (this.sequencer.isOpen()) {
            this.sequencer.stop();
            this.sequencer.close();
        }
    }

    public void play(boolean bl) {
        this.replay = bl;
        this.t = new Thread(this);
        this.t.start();
    }

    private void findDirectionChange() {
        Color color;
        int n;
        int n2;
        int n3;
        this.newMessage(192, 9, 1, 0L);
        int n4 = 1;
        while (n4 < this.coords.length - 1) {
            n3 = this.getTick(n4, this.coords.length);
            n2 = this.coords[n4][0] - this.coords[n4 - 1][0];
            n = this.coords[n4 + 1][0] - this.coords[n4][0];
            if (this.isNegative(n4, 0)) {
                color = (Color)this.timbre.get(new Integer(n4));
                this.newMessage(144, 9, this.noises.getInstrument(color, 0), n3);
                this.newMessage(128, 9, this.noises.getInstrument(color, 0), n3 + 1);
            }
            if (n2 * n == 0) {
                n4 += 2;
                continue;
            }
            ++n4;
        }
        n4 = 1;
        while (n4 < this.coords.length - 1) {
            n3 = this.getTick(n4, this.coords.length);
            n2 = this.coords[n4][1] - this.coords[n4 - 1][1];
            n = this.coords[n4 + 1][1] - this.coords[n4][1];
            if (this.isNegative(n4, 1)) {
                color = (Color)this.timbre.get(new Integer(n4));
                if (this.up) {
                    this.newMessage(144, 9, this.noises.getInstrument(color, 1), n3);
                    this.newMessage(128, 9, this.noises.getInstrument(color, 1), n3 + 1);
                } else {
                    this.newMessage(144, 9, this.noises.getInstrument(color, 2), n3);
                    this.newMessage(128, 9, this.noises.getInstrument(color, 2), n3 + 1);
                }
            }
            if (n2 * n == 0) {
                n4 += 2;
                continue;
            }
            ++n4;
        }
        this.newMessage(192, 9, 1, 15L);
    }

    private boolean isNegative(int n, int n2) {
        for (int i = 1; i < 6; ++i) {
            int n3;
            int n4 = 0;
            int n5 = 0;
            n4 = n - i < 0 ? 1 : i;
            int n6 = this.coords[n][n2] - this.coords[n - n4][n2];
            if (n6 * (n3 = this.coords[n + (n5 = n + i >= this.coords.length ? this.coords.length - n - 1 : i)][n2] - this.coords[n][n2]) < 0) {
                this.up = n6 > n3;
                return true;
            }
            if (n6 * n3 <= 0) continue;
            return false;
        }
        return false;
    }

    private int getTick(int n, int n2) {
        float f = n;
        float f2 = n2;
        float f3 = 16.0f * f / (float)n2;
        int n3 = Math.round(f3) + this.offset;
        return n3;
    }

    private int updateOffset(int n) {
        if (n < 2) {
            return 0;
        }
        return 16;
    }

    private void newMessage(int n, int n2, int n3, long l) {
        ShortMessage shortMessage = new ShortMessage();
        try {
            shortMessage.setMessage(n, n2, n3, 100);
            MidiEvent midiEvent = new MidiEvent(shortMessage, l);
            this.track.add(midiEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

