/*
 * Decompiled with CFR 0.152.
 */
package com.sanitysewer.sketch;

import com.sanitysewer.common.GeometryChecker;
import com.sanitysewer.common.Interpolater;
import com.sanitysewer.common.QuiltBoardMappings;
import com.sanitysewer.sketch.OrganGrinder;
import com.sanitysewer.sketch.ScribbleSegment;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;

class DrawPad
extends JComponent {
    Image image;
    Graphics2D graphics2D;
    int currentX;
    int currentY;
    int oldX;
    int oldY;
    int startDragX;
    int startDragY;
    Vector segments = new Vector(18);
    Vector play_order = new Vector(18);
    ScribbleSegment scribble;
    boolean begin = true;
    long last;
    Color lineColor = Color.blue;
    QuiltBoardMappings quilt = new QuiltBoardMappings();
    OrganGrinder og = null;
    boolean replay = false;
    int count = 0;
    GeometryChecker geomch = new GeometryChecker();
    Interpolater intpol = new Interpolater();
    int active_scribble = -1;
    boolean active_is_draggable = false;
    boolean was_just_dragged = false;
    boolean hasChange = false;

    public DrawPad(Vector vector, boolean bl) {
        this.segments = vector;
        this.replay = bl;
        this.og = new OrganGrinder(vector, this.play_order, this);
    }

    public DrawPad(int n, int n2) {
        this.setDoubleBuffered(false);
        this.setFocusable(true);
        this.setPreferredSize(new Dimension(n, n2));
        this.og = new OrganGrinder(this.segments, this.play_order, this);
        this.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                DrawPad.this.hasChange = true;
                if (keyEvent.getKeyCode() == 27) {
                    System.exit(0);
                } else if (DrawPad.this.quilt.isActiveQuiltKey(keyEvent.getKeyCode())) {
                    String string = DrawPad.this.quilt.getQuiltKeyName(keyEvent.getKeyCode());
                    if (string == "x") {
                        DrawPad.this.lineColor = Color.orange;
                        DrawPad.this.graphics2D.setPaint(new Color(255, 164, 0));
                    } else if (string == "y") {
                        DrawPad.this.lineColor = Color.red;
                        DrawPad.this.graphics2D.setPaint(DrawPad.this.lineColor);
                    } else if (string == "z") {
                        DrawPad.this.lineColor = Color.yellow;
                        DrawPad.this.graphics2D.setPaint(DrawPad.this.lineColor);
                    } else if (string == "i") {
                        DrawPad.this.lineColor = Color.blue;
                        DrawPad.this.graphics2D.setPaint(DrawPad.this.lineColor);
                    } else if (string == "j") {
                        DrawPad.this.lineColor = Color.magenta;
                        DrawPad.this.graphics2D.setPaint(DrawPad.this.lineColor);
                    } else if (string == "+") {
                        DrawPad.this.lineColor = Color.cyan;
                        DrawPad.this.graphics2D.setPaint(DrawPad.this.lineColor);
                    } else if (string == "duck") {
                        DrawPad.this.playIt();
                    } else if (string == "-") {
                        if (DrawPad.this.active_scribble >= 0) {
                            DrawPad.this.segments.remove(DrawPad.this.active_scribble);
                            DrawPad.this.active_scribble = -1;
                            DrawPad.this.active_is_draggable = false;
                            DrawPad.this.replay = false;
                            DrawPad.this.updateScreen(DrawPad.this.segments);
                        }
                    } else if (string == "o") {
                        DrawPad.this.og.switchLooping();
                        DrawPad.this.playIt();
                    } else if (string == "blank") {
                        DrawPad.this.clear();
                        DrawPad.this.og.clear();
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                DrawPad.this.hasChange = true;
                if (DrawPad.this.whichScribbleClicked(mouseEvent) == DrawPad.this.active_scribble && DrawPad.this.active_scribble >= 0) {
                    DrawPad.this.startDragX = mouseEvent.getX();
                    DrawPad.this.startDragY = mouseEvent.getY();
                    DrawPad.this.active_is_draggable = true;
                } else {
                    DrawPad.this.scribble = new ScribbleSegment();
                    DrawPad.this.oldX = mouseEvent.getX();
                    DrawPad.this.oldY = mouseEvent.getY();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                DrawPad.this.hasChange = true;
                if (DrawPad.this.scribble.size() > 0) {
                    DrawPad.this.segments.add(DrawPad.this.scribble);
                } else if (DrawPad.this.was_just_dragged) {
                    DrawPad.this.was_just_dragged = false;
                    DrawPad.this.updateScreen(DrawPad.this.segments);
                } else {
                    for (int i = 0; i < DrawPad.this.segments.size(); ++i) {
                        ScribbleSegment scribbleSegment = (ScribbleSegment)DrawPad.this.segments.get(i);
                        if (DrawPad.this.geomch.isPointNearLine(scribbleSegment.getCoords(), mouseEvent.getX(), mouseEvent.getY(), 7)) {
                            if (DrawPad.this.active_scribble == i) {
                                DrawPad.this.active_scribble = -1;
                                DrawPad.this.active_is_draggable = false;
                                DrawPad.this.updateScreen(DrawPad.this.segments);
                                break;
                            }
                            DrawPad.this.active_scribble = i;
                            DrawPad.this.updateScreen(DrawPad.this.segments);
                            break;
                        }
                        DrawPad.this.active_scribble = -1;
                        DrawPad.this.updateScreen(DrawPad.this.segments);
                    }
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                DrawPad.this.replay = false;
                DrawPad.this.hasChange = true;
                if (DrawPad.this.active_scribble < 0) {
                    DrawPad.this.currentX = mouseEvent.getX();
                    DrawPad.this.currentY = mouseEvent.getY();
                    if (Math.abs(DrawPad.this.oldX - DrawPad.this.currentX) > 15 || Math.abs(DrawPad.this.oldY - DrawPad.this.currentY) > 15) {
                        Vector vector = DrawPad.this.intpol.interpolateLinearlyToThreshold(new Vector(), DrawPad.this.oldX, DrawPad.this.oldY, DrawPad.this.currentX, DrawPad.this.currentY, 15);
                        int n = DrawPad.this.oldX;
                        int n2 = DrawPad.this.oldY;
                        for (int i = 0; i < vector.size(); ++i) {
                            int[] nArray = (int[])vector.get(i);
                            DrawPad.this.scribble.addCoordinate(nArray[0], nArray[1], DrawPad.this.lineColor);
                            if (DrawPad.this.graphics2D != null) {
                                DrawPad.this.graphics2D.drawLine(n, n2, nArray[0], nArray[1]);
                            }
                            n = nArray[0];
                            n2 = nArray[1];
                        }
                    } else {
                        DrawPad.this.scribble.addCoordinate(DrawPad.this.currentX, DrawPad.this.currentY, DrawPad.this.lineColor);
                        if (DrawPad.this.graphics2D != null) {
                            DrawPad.this.graphics2D.drawLine(DrawPad.this.oldX, DrawPad.this.oldY, DrawPad.this.currentX, DrawPad.this.currentY);
                        }
                    }
                    DrawPad.this.repaint();
                    DrawPad.this.oldX = DrawPad.this.currentX;
                    DrawPad.this.oldY = DrawPad.this.currentY;
                } else if (DrawPad.this.active_is_draggable) {
                    DrawPad.this.was_just_dragged = true;
                    int n = mouseEvent.getX();
                    int n3 = mouseEvent.getY();
                    int n4 = n - DrawPad.this.startDragX;
                    int n5 = n3 - DrawPad.this.startDragY;
                    DrawPad.this.startDragX = n;
                    DrawPad.this.startDragY = n3;
                    ScribbleSegment scribbleSegment = (ScribbleSegment)DrawPad.this.segments.get(DrawPad.this.active_scribble);
                    scribbleSegment.updateCoords(n4, n5);
                    DrawPad.this.updateScreen(DrawPad.this.segments);
                }
            }
        });
    }

    public Vector getSegments() {
        return this.segments;
    }

    public Vector getPlayOrder() {
        return this.play_order;
    }

    public boolean hasChange() {
        return this.hasChange;
    }

    public void setChange(boolean bl) {
        this.hasChange = bl;
    }

    private void updateScreen(Vector vector) {
        Graphics2D graphics2D;
        BufferedImage bufferedImage = new BufferedImage(this.getSize().width, this.getSize().height, 5);
        this.graphics2D = graphics2D = (Graphics2D)bufferedImage.getGraphics();
        this.graphics2D.setPaint(Color.GREEN);
        this.graphics2D.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.graphics2D.setPaint(this.lineColor);
        for (int i = 0; i < vector.size(); ++i) {
            ScribbleSegment scribbleSegment = (ScribbleSegment)vector.get(i);
            Vector vector2 = scribbleSegment.getCoords();
            for (int j = 0; j < vector2.size(); ++j) {
                int[] nArray = (int[])vector2.get(j);
                int[] nArray2 = j + 1 < vector2.size() ? (int[])vector2.get(j + 1) : nArray;
                this.graphics2D.setPaint(scribbleSegment.getTimbre(j));
                if (i == this.active_scribble) {
                    BasicStroke basicStroke = (BasicStroke)this.graphics2D.getStroke();
                    this.graphics2D.setStroke(new BasicStroke(basicStroke.getLineWidth() * 3.25f));
                    this.graphics2D.drawLine(nArray[0], nArray[1], nArray2[0], nArray2[1]);
                    this.graphics2D.setStroke(basicStroke);
                }
                this.graphics2D.drawLine(nArray[0], nArray[1], nArray2[0], nArray2[1]);
            }
        }
        this.image = bufferedImage;
        this.graphics2D.drawImage(this.image, 0, 0, null);
        this.repaint();
    }

    public void updatePlayOrder(Vector vector) {
        Hashtable hashtable = new Hashtable(18);
        this.play_order.removeAllElements();
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = new Vector(18);
            if (hashtable.contains(new Integer(i))) continue;
            ScribbleSegment scribbleSegment = (ScribbleSegment)vector.get(i);
            Vector vector3 = scribbleSegment.getCoords();
            boolean bl = false;
            for (int j = 0; j < vector.size(); ++j) {
                ScribbleSegment scribbleSegment2;
                Vector vector4;
                if (i == j || !this.geomch.areIntersectingBoxes(vector3, vector4 = (scribbleSegment2 = (ScribbleSegment)vector.get(j)).getCoords(), 1) || !this.geomch.doLinesCross(vector3, vector4)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                vector2.add(new Integer(i));
                hashtable.put(new Integer(i), new Integer(i));
                Object[] objectArray = this.checkNeighboringForIntersections(i, vector2, vector3, vector, hashtable);
                vector2 = (Vector)objectArray[0];
                hashtable = (Hashtable)objectArray[1];
            }
            if (vector2.size() <= 0) continue;
            this.play_order.add(vector2);
        }
    }

    private Object[] checkNeighboringForIntersections(int n, Vector vector, Vector vector2, Vector vector3, Hashtable hashtable) {
        for (int i = 0; i < vector3.size(); ++i) {
            ScribbleSegment scribbleSegment;
            Vector vector4;
            if (n == i || !this.geomch.areIntersectingBoxes(vector2, vector4 = (scribbleSegment = (ScribbleSegment)vector3.get(i)).getCoords(), 0) || !this.geomch.doLinesCross(vector2, vector4)) continue;
            if (!hashtable.contains(new Integer(i))) {
                vector.add(new Integer(i));
                hashtable.put(new Integer(i), new Integer(i));
            }
            Object[] objectArray = this.checkNeighboringForIntersections(i, vector, vector4, vector3, hashtable);
            vector = (Vector)objectArray[0];
            hashtable = (Hashtable)objectArray[1];
        }
        Object[] objectArray = new Object[]{vector, hashtable};
        return objectArray;
    }

    private int whichScribbleClicked(MouseEvent mouseEvent) {
        for (int i = 0; i < this.segments.size(); ++i) {
            ScribbleSegment scribbleSegment = (ScribbleSegment)this.segments.get(i);
            if (!this.geomch.isPointNearLine(scribbleSegment.getCoords(), mouseEvent.getX(), mouseEvent.getY(), 5)) continue;
            return i;
        }
        return -1;
    }

    private void playIt() {
        if (!this.replay) {
            this.updatePlayOrder(this.segments);
            this.og.updateSegments(this.segments, this.play_order);
            this.og.play(false);
            this.replay = true;
        } else {
            this.og.play(true);
        }
    }

    public void paintComponent(Graphics graphics) {
        if (this.image == null) {
            this.image = this.createImage(this.getSize().width, this.getSize().height);
            this.graphics2D = (Graphics2D)this.image.getGraphics();
            this.clear();
        }
        graphics.drawImage(this.image, 0, 0, null);
    }

    public void clear() {
        this.segments.clear();
        this.replay = false;
        this.active_scribble = -1;
        this.active_is_draggable = false;
        this.was_just_dragged = false;
        this.graphics2D.setPaint(Color.GREEN);
        this.graphics2D.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.graphics2D.setPaint(this.lineColor);
        this.repaint();
    }
}

