/*
 * Decompiled with CFR 0.152.
 */
package com.sanitysewer.circlesynth;

import com.sanitysewer.circlesynth.SoundCircleJComponent;
import com.sanitysewer.circlesynth.Synth;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;

public class SynthJComponent
extends JPanel
implements MouseListener {
    SoundCircleJComponent[] circles = new SoundCircleJComponent[4];
    Synth synth = new Synth();
    Color[] colors;
    int count = 0;
    int active = 0;
    int w;

    public SynthJComponent(int n, int n2, Color[] colorArray) {
        this.w = n;
        this.colors = colorArray;
        this.setPreferredSize(new Dimension(n, n2));
        this.setBackground(colorArray[0]);
        this.setLayout(new GridLayout(4, 1));
    }

    public void addCircle(int n) {
        if (this.count < this.circles.length) {
            this.circles[this.count] = new SoundCircleJComponent(this.w, n, this.colors);
            this.circles[this.count].addMouseListener(this);
            this.add(this.circles[this.count]);
            this.synth.addOscillator(this.circles[this.count].getOscillator());
            this.active = this.count++;
        }
    }

    public void removeCircle() {
        int n = this.count - 1;
        if (n >= 0) {
            this.remove(this.circles[this.active]);
            this.synth.removeOscillator(this.active);
            for (int i = this.active; i < n; ++i) {
                this.circles[i] = this.circles[i + 1];
            }
            this.circles[n] = null;
            --this.count;
            this.active = n - 1;
        }
    }

    public void changeFreq(int n) {
        int n2 = n + this.circles[this.active].getFrequency();
        this.synth.removeOscillator(this.active);
        this.circles[this.active].setFrequency(n2);
        this.synth.addOscillator(this.circles[this.active].getOscillator());
    }

    public int getCount() {
        return this.count;
    }

    public void play() {
        this.synth.play();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof SoundCircleJComponent) {
            for (int i = 0; i < this.circles.length; ++i) {
                if (this.circles[i] != (SoundCircleJComponent)mouseEvent.getSource()) continue;
                this.active = i;
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }
}

