/*
 * Decompiled with CFR 0.152.
 */
package com.sanitysewer.circlesynth;

import com.sanitysewer.circlesynth.Oscillator;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class Synth {
    Oscillator[] os = new Oscillator[4];
    int count = 0;
    AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 22050.0f, 16, 1, 2, 22050.0f, true);
    DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = Synth.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, this.format);
    SourceDataLine sdl = null;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public Synth() {
        try {
            this.sdl = (SourceDataLine)AudioSystem.getLine(this.info);
            this.sdl.open();
            this.sdl.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Oscillator[] getOscillators() {
        return this.os;
    }

    public void addOscillator(Oscillator oscillator) {
        if (this.count < this.os.length) {
            this.os[this.count] = oscillator;
            ++this.count;
        }
    }

    public void removeOscillator(int n) {
        int n2 = this.count - 1;
        if (n2 >= 0) {
            for (int i = n; i < n2; ++i) {
                this.os[i] = this.os[i + 1];
            }
        }
        this.os[n2] = null;
        --this.count;
    }

    public void play() {
        if (this.count > 0) {
            int n = 32768;
            byte[][] byArray = new byte[this.count][n];
            for (int i = 0; i < this.count; ++i) {
                try {
                    this.os[i].read(byArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println("i: " + i + " os length: " + this.os.length);
                }
            }
            byte[] byArray2 = new byte[n];
            for (int i = 0; i < n; i += 2) {
                int n2;
                int n3 = 0;
                for (n2 = 0; n2 < byArray.length; ++n2) {
                    short s = this.getShort(byArray[n2][i], byArray[n2][i + 1]);
                    n3 += s;
                }
                n2 = (short)(n3 / byArray.length);
                byArray2[i] = (byte)(n2 >> 8);
                byArray2[i + 1] = (byte)n2;
            }
            this.sdl.write(byArray2, 0, n);
        }
    }

    private short getShort(byte by, byte by2) {
        int n = by & 0xFF;
        int n2 = by2 & 0xFF;
        short s = (short)(n << 8 | n2);
        return s;
    }

    public static void main(String[] stringArray) {
        Synth synth = new Synth();
        synth.addOscillator(new Oscillator(220, 0));
        synth.addOscillator(new Oscillator(410, 0));
        synth.addOscillator(new Oscillator(630, 0));
        while (true) {
            synth.play();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

