/*
 * Decompiled with CFR 0.152.
 */
package com.sanitysewer.circlesynth;

import com.sanitysewer.circlesynth.Oscillator;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public class SoundCircleJComponent
extends JComponent
implements Runnable {
    Color bgColor;
    Color fgColor1;
    Color fgColor2;
    int w;
    int freq;
    Oscillator pacer;
    Oscillator os;
    short val = 0;
    short lastval = 0;
    Thread t;

    public SoundCircleJComponent(int n, int n2, Color[] colorArray) {
        this.setDoubleBuffered(true);
        this.bgColor = colorArray[0];
        this.fgColor1 = colorArray[1];
        this.fgColor2 = colorArray[2];
        this.w = n;
        this.freq = n2;
        this.os = new Oscillator(this.freq, 0);
        this.pacer = new Oscillator(1, 0);
        this.t = new Thread(this);
        this.t.start();
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setPaint(this.bgColor);
        graphics2D.fillRect(0, 0, this.w, this.w);
        int n = (int)((double)this.w * 0.8 / 2.0);
        int n2 = (int)((double)this.w - (double)this.w * 0.9);
        int n3 = this.w / 2;
        graphics2D.setPaint(this.fgColor1);
        graphics2D.fillOval(n2, n2, 2 * n, 2 * n);
        graphics2D.setPaint(this.fgColor2);
        int n4 = 1;
        if (this.val > this.lastval) {
            n4 = 1;
        } else if (this.val < this.lastval) {
            n4 = -1;
        }
        int n5 = (int)((double)this.val / 32766.0 * (double)n);
        int n6 = (int)(Math.cos(Math.asin((double)this.val / 32766.0)) * (double)n);
        graphics2D.drawLine(n3, n3, n3 + n4 * n6, n3);
        graphics2D.drawLine(n3 + n4 * n6, n3, n3 + n4 * n6, n3 - n5);
        graphics2D.drawLine(n3, n3, n3 + n4 * n6, n3 - n5);
        int n7 = (int)((double)n * 0.1);
        graphics2D.fillOval(n3 + n4 * n6 - n7, n3 - n5 - n7, n7 * 2, n7 * 2);
    }

    public Oscillator getOscillator() {
        return this.os;
    }

    public int getFrequency() {
        return this.freq;
    }

    public void setFrequency(int n) {
        this.freq = n;
        this.os = new Oscillator(this.freq, 0);
    }

    public Thread getThread() {
        return this.t;
    }

    public void run() {
        try {
            int n = 0;
            while (true) {
                if (n >= 44100 - this.freq * 4) {
                    n = 0;
                }
                this.lastval = this.val;
                this.val = this.pacer.getValueAt(n += this.freq * 5);
                if (this.getParent() != null) {
                    this.getParent().repaint();
                }
                Thread.sleep(33L);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }
}

