/*
 * Decompiled with CFR 0.152.
 */
package com.sanitysewer.circlesynth;

import com.sanitysewer.circlesynth.ColorPallette;
import com.sanitysewer.circlesynth.SynthJComponent;
import com.sanitysewer.circlesynth.WorkArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class CircleSynth
extends JPanel
implements Runnable,
KeyListener,
MouseListener,
MouseMotionListener {
    Color bkgrnd = new Color(127, 127, 255);
    SynthJComponent sjc;
    SynthJComponent[] sjcs = new SynthJComponent[8];
    WorkArea wa;
    final int MAXSYNTHS = 8;
    int count = 0;
    int w;
    int h;
    int localX = 0;
    int localY = 0;
    int active;

    public CircleSynth(int n, int n2) {
        this.addKeyListener(this);
        this.setLayout(new BorderLayout());
        this.w = n;
        this.h = n2;
        this.wa = new WorkArea(n, n2, this.bkgrnd);
        this.add((Component)this.wa, "Center");
        this.addContainerListener(new ContainerAdapter(){

            public void componentRemoved(ContainerEvent containerEvent) {
                if (CircleSynth.this.sjcs[CircleSynth.this.active].getCount() == 0) {
                    CircleSynth.this.sjcs[CircleSynth.this.active] = null;
                }
            }
        });
        Thread thread = new Thread(this);
        thread.start();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            System.exit(0);
        } else if (keyEvent.getKeyCode() == 65) {
            this.sjcs[this.active].addCircle(440);
            this.updateUI();
        } else if (keyEvent.getKeyCode() == 83) {
            this.sjcs[this.active].removeCircle();
            this.updateUI();
        } else if (keyEvent.getKeyCode() == 81) {
            this.addSyntJComponent(ColorPallette.getColors(0));
        } else if (keyEvent.getKeyCode() == 87) {
            this.addSyntJComponent(ColorPallette.getColors(1));
        } else if (keyEvent.getKeyCode() == 69) {
            this.addSyntJComponent(ColorPallette.getColors(2));
        } else if (keyEvent.getKeyCode() == 82) {
            this.addSyntJComponent(ColorPallette.getColors(3));
        } else if (keyEvent.getKeyCode() == 84) {
            this.addSyntJComponent(ColorPallette.getColors(4));
        } else if (keyEvent.getKeyCode() == 89) {
            this.addSyntJComponent(ColorPallette.getColors(5));
        } else if (keyEvent.getKeyCode() == 85) {
            this.addSyntJComponent(ColorPallette.getColors(6));
        } else if (keyEvent.getKeyCode() == 73) {
            this.addSyntJComponent(ColorPallette.getColors(7));
        } else if (keyEvent.getKeyCode() == 77) {
            this.sjcs[this.active].changeFreq(10);
        } else if (keyEvent.getKeyCode() == 76) {
            this.sjcs[this.active].changeFreq(-10);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof SynthJComponent) {
            for (int i = 0; i < this.sjcs.length; ++i) {
                if (this.sjcs[i] != (SynthJComponent)mouseEvent.getSource()) continue;
                this.active = i;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof SynthJComponent) {
            if (this.localX == 0 || this.localY == 0) {
                this.localX = mouseEvent.getX();
                this.localY = mouseEvent.getY();
            }
            int n = mouseEvent.getX() - this.localX;
            int n2 = mouseEvent.getY() - this.localY;
            this.sjcs[this.active].setLocation(this.sjcs[this.active].getX() + n, this.sjcs[this.active].getY() + n2);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void run() {
        while (true) {
            if (this.sjcs[this.active] == null) {
                continue;
            }
            this.sjcs[this.active].play();
        }
    }

    private void addSyntJComponent(Color[] colorArray) {
        if (this.count < 8) {
            this.sjcs[this.count] = new SynthJComponent(this.w / 8, this.w / 8 * 4, colorArray);
            this.sjcs[this.count].addMouseListener(this);
            this.sjcs[this.count].addMouseMotionListener(this);
            this.sjcs[this.count].addCircle(220);
            this.sjcs[this.count].setBounds(100, 100, this.w / 8, this.w / 8 * 4);
            this.wa.add(this.sjcs[this.count]);
            this.active = this.count++;
        }
        this.updateUI();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        GraphicsConfiguration graphicsConfiguration = jFrame.getGraphicsConfiguration();
        int n = graphicsConfiguration.getBounds().width;
        int n2 = graphicsConfiguration.getBounds().height;
        CircleSynth circleSynth = new CircleSynth(n, n2);
        circleSynth.setFocusable(true);
        jFrame.transferFocus();
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(circleSynth);
        container.add((Component)jPanel, "Center");
        jFrame.setUndecorated(true);
        jFrame.setSize(n, n2);
        jFrame.setLocation(new Point(0, 0));
        jFrame.setVisible(true);
    }
}

