package com.sanitysewer;

import java.awt.*;

public class WireFrame {
    private double [][][] model;
    private double rotation, rotinc;
    private double [][] rothistory;

    private int spin;

    public WireFrame(double[][] c, double r, double s, int sp) {
	this.model = new double[c.length][(int)(r/s)+1][3];
	this.rotation = Math.toRadians(r);
	this.rotinc = Math.toRadians(s);
	this.spin = sp;

	populate(c);

	double [][] rh = { {1, 0, 0, 0},
			   {0, 1, 0, 0},
			   {0, 0, 1, 0},
			   {0, 0, 0, 1} };		       
	rothistory = rh;

    }


    private void populate(double[][] c) {

	for (int i=0; i<c.length; i++) {
	    double nextrot = 0.0;

	    for (int j=0; j<model[i].length; j++) {
		model[i][j] = spin(c[i], nextrot);
		nextrot += rotinc;
	    }
	}
    }
    
    
    private double[] spin(double [] xy, double alpha) {
	double [] xy_out = new double[3];

	// first, translate the center to origin
      	xy[0] -= (double)Common.WIDTH/2.0;
	xy[1] -= (double)Common.HEIGHT/2.0;

	switch (spin) {
	case Common.YSPIN:
	    // rotate around the y-axis
	    xy_out[0] = xy[0]*Math.cos(alpha) + xy[2]*Math.sin(alpha);
	    xy_out[1] = xy[1];
	    xy_out[2] = -1 * xy[0]*Math.sin(alpha) + xy[2]*Math.cos(alpha);
	    break;
	case Common.XSPIN:
	    xy_out[0] = xy[0];
	    xy_out[1] = xy[1]*Math.cos(alpha) + -1*xy[2]*Math.sin(alpha);
	    xy_out[2] = xy[1]*Math.sin(alpha) + xy[2]*Math.cos(alpha);
	    break;
	}

	// translate back to original position in screen coordinates
 	xy_out[0] += (double)Common.WIDTH/2.0; 
	xy_out[1] += (double)Common.HEIGHT/2.0;
	xy[0] += (double)Common.WIDTH/2.0;
	xy[1] += (double)Common.HEIGHT/2.0;

	return xy_out;
    }


    /* rotates the model */
    public void rotate(double dx, double dy) {

	dy = Math.toRadians(dy);
	dx = Math.toRadians(dx);
	
	history(dx, dy);

	for (int i=0; i<model.length; i++) {
	    for (int j=0; j<model[i].length; j++) {
		// translate to origin
		model[i][j][0] -= (double)Common.WIDTH/2.0;
		model[i][j][1] -= (double)Common.HEIGHT/2.0;

		// store in temporary variables
		double x, y, z;
		x = model[i][j][0]; y = model[i][j][1]; z = model[i][j][2];

		// rotate aroung y-axis
		model[i][j][0] = x*Math.cos(dx) + z*Math.sin(dx);
		model[i][j][2] = -1*x*Math.sin(dx) + z*Math.cos(dx);

		// reset temp variable with new values
 		x = model[i][j][0]; y = model[i][j][1]; z = model[i][j][2];

		// rotate around x-axis
		model[i][j][1] = y*Math.cos(dy) - z*Math.sin(dy);
		model[i][j][2] = y*Math.sin(dy) + z*Math.cos(dy);
		

		// translate back to original location in screen coordinates
		model[i][j][0] += (double)Common.WIDTH/2.0;
		model[i][j][1] += (double)Common.HEIGHT/2.0;
		
	    }
	}
    }


    public double[][][] getModel() { return model; }


    private void history(double dx, double dy) {


	// now around the y-axis
	double [][] roty = { {Math.cos(dx), 0, Math.sin(dx), 0},
			     {0, 1, 0, 0}, 
			     {-1*Math.sin(dx), 0, Math.cos(dx), 0},
			     {0, 0, 0, 1} }; 

	rothistory = Matrix.matrixMul4x4(rothistory, roty);

	// store the rotations around x-axis
	double [][] rotx = { {1, 0, 0, 0},
			     {0, Math.cos(dy), -1*Math.sin(dy), 0}, 
			     {0, Math.sin(dy), Math.cos(dy), 0},
			     {0, 0, 0, 1} };

	rothistory = Matrix.matrixMul4x4(rothistory, rotx);

    }


    public double[][] getRotationHistory() { return rothistory; }
    public void setRotationHistory(double [][] rh) { rothistory = rh; }

    

    public void updateByMatrix(double [][] rh) {

	for (int i=0; i<model.length; i++) {
	    for (int j=0; j<model[i].length; j++) {
		double [] xyzw = new double[4];
		xyzw[0] =  model[i][j][0] - (double)Common.WIDTH/2.0;
		xyzw[1] =  model[i][j][1] - (double)Common.HEIGHT/2.0;
		xyzw[2] =  model[i][j][2];
		xyzw[3] =  1.0;

		xyzw = Matrix.matrix4MulVec4(rh, xyzw);

		model[i][j][0] = xyzw[0] + (double)Common.WIDTH/2.0;
		model[i][j][1] = xyzw[1] + (double)Common.HEIGHT/2.0;
		model[i][j][2] = xyzw[2];
	    }

	}
    }



    public void dump() {

	for (int i=0; i<model.length; i++) {
	    for (int j=0; j<model[i].length; j++) {
		System.out.println(model[i][j][0] + "\t" + model[i][j][1] + "\t" + model[i][j][2]);
	    }
	}

    }


}


