package com.sanitysewer;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import java.util.*;


public class VesselViewer extends JApplet {

    public void init() {

 	VesselViewerPanel vvp = new VesselViewerPanel();

	JPanel p = new JPanel(new BorderLayout());
	p.add(vvp, "Center");
	getContentPane().add(p);


    }

}


class VesselViewerPanel extends JPanel implements ActionListener {
    private ViewingArea va;
    private ControlArea ca;




    public VesselViewerPanel() {
	this.setPreferredSize(new Dimension(Common.WIDTH, Common.HEIGHT));
	this.setLayout(new BorderLayout());

	// menu area
	this.add(buildMenu(), BorderLayout.NORTH);

	// viewing and control areas are in their own panel
	JPanel p = new JPanel(new BorderLayout());

	va = new ViewingArea(Common.WIDTH, Common.HEIGHT);
	p.add(va, BorderLayout.CENTER);

	ca = new ControlArea(va, 360, HEIGHT);
	p.add(ca, BorderLayout.EAST);

	this.add(p, BorderLayout.CENTER);

    }


    private JMenuBar buildMenu() {

	// Menu
	JMenuBar menuBar = new JMenuBar();
	
	JMenu optionMenu= new JMenu("Options");
	optionMenu.setMnemonic(KeyEvent.VK_O);
	menuBar.add(optionMenu);

	ButtonGroup modeGroup = new ButtonGroup();
	JRadioButtonMenuItem rbItem;
	rbItem = new JRadioButtonMenuItem("Bézier Curve");
	rbItem.setSelected(true);
	modeGroup.add(rbItem); optionMenu.add(rbItem);
	rbItem.addActionListener(this);
	rbItem = new JRadioButtonMenuItem("B-Spline Curve");
	modeGroup.add(rbItem); optionMenu.add(rbItem);
	rbItem.addActionListener(this);
	optionMenu.add(rbItem);

	optionMenu.addSeparator();

	ButtonGroup rotateGroup = new ButtonGroup();
	JRadioButtonMenuItem rotItem;
	rotItem = new JRadioButtonMenuItem("Spin y-axis");
	rotItem.setSelected(true);
	rotItem.addActionListener(this);
	rotateGroup.add(rotItem); optionMenu.add(rotItem);
	rotItem = new JRadioButtonMenuItem("Spin x-axis");
	rotItem.addActionListener(this);
	rotateGroup.add(rotItem); optionMenu.add(rotItem);

	optionMenu.addSeparator();
	ButtonGroup lightingGroup = new ButtonGroup();
	JRadioButtonMenuItem lightItem;
	lightItem = new JRadioButtonMenuItem("Constant Lighting");
	lightItem.addActionListener(this);
	lightItem.setSelected(true);
	lightingGroup.add(lightItem);  optionMenu.add(lightItem);

	optionMenu.addSeparator();

	JMenuItem resetItem = new JMenuItem("Clear");
	resetItem.setMnemonic(KeyEvent.VK_C);
	resetItem.setToolTipText("Clear current image");
	resetItem.addActionListener(this);
	optionMenu.add(resetItem);

	JMenu viewMenu = new JMenu("View");
	viewMenu.setMnemonic(KeyEvent.VK_V);
	menuBar.add(viewMenu);

	ButtonGroup viewGroup = new ButtonGroup();
	JRadioButtonMenuItem vbItem;
	vbItem = new JRadioButtonMenuItem("2D Curve Only");
	vbItem.setSelected(true);
	vbItem.addActionListener(this);
	viewGroup.add(vbItem); viewMenu.add(vbItem);
	vbItem = new JRadioButtonMenuItem("3D Wire Frame (faster)");
	vbItem.addActionListener(this);
	viewGroup.add(vbItem); viewMenu.add(vbItem);	
	vbItem = new JRadioButtonMenuItem("Polygon Faces (slower)");
	vbItem.addActionListener(this);
	viewGroup.add(vbItem); viewMenu.add(vbItem);

	

	return menuBar;
    }

    public void actionPerformed(ActionEvent ae) {
	JMenuItem source = (JMenuItem)(ae.getSource());

	if (source.getText().equals("Exit")){
	    System.exit(0);
	}
	else if (source.getText().equals("Clear")){
	    va.clear();
	}
	else if (source.getText().equals("2D Curve Only")) {
	    va.setMode(Common.CURVE2D);
	    va.buildCurve();
	}
	else if (source.getText().equals("3D Wire Frame (faster)")) {
	    if (va.canBuildModel()) {
		va.setMode(Common.WIREFRAME);
		va.buildWireFrame();
	    }
	}
	else if (source.getText().equals("Polygon Faces (slower)")) {
	    if (va.canBuildModel()) {
		va.setMode(Common.POLYGONS);
		va.buildSolidFrame();
	    }
	}
	else if (source.getText().equals("Spin y-axis")) {
	    va.setSpinDirection(Common.YSPIN);
	}
	else if (source.getText().equals("Spin x-axis")) {
	    va.setSpinDirection(Common.XSPIN);
	}
	else if (source.getText().equals("Bézier Curve")) {
	    va.setCurve(Common.BEZIER);
	}
	else if (source.getText().equals("B-Spline Curve")) {
	    va.setCurve(Common.BSPLINE);
	}
	else if (source.getText().equals("Constant Lighting")) {
	    va.setLightingMode(Common.CONSTANT);
	}
	else if (source.getText().equals("Gouraud Lighting")) {
	    va.setLightingMode(Common.GOURAUD);
	}
	
    }


}


class ControlArea extends JPanel implements ChangeListener, ActionListener {
    private int w;
    private int h;
    private ViewingArea va;

    private JSlider intervals, rotsteps, rotation;
    private JSlider ka, kd, intensity, xslider, yslider, zslider;

    private double [] xyzl1 = new double[3];
    private double [] xyzl2 = new double[3];
    private double il1, il2; // intenisty for light 1 and light 2
    private int activelight = 1;

    public ControlArea(ViewingArea v, int width, int height) {
	this.va = v;
	this.w = width;
	this.h = height;

	this.setPreferredSize(new Dimension(w, h));
	this.setLayout(new BorderLayout());

	JPanel top = buildSliderPanel();

	JPanel bottom = new JPanel(new BorderLayout());

	xyzl1[0] = 0.0; xyzl1[1] = 0; xyzl1[2] = 0.0;
	xyzl2[0] = 0.0; xyzl2[1] = 0; xyzl2[2] = 25.0;
	il1 = 75.0;  il2 = 75.0;
	bottom.add(buildLightingPanel(), BorderLayout.CENTER);

	va.addLight(il1, xyzl1[0], xyzl1[1], xyzl1[2], Common.BACKGROUND);
	va.addLight(il2, xyzl2[0], xyzl2[1], xyzl2[2], Common.POINT);
	va.setSurface((double)ka.getValue(), (double)kd.getValue());

	this.add(top, BorderLayout.NORTH);
	this.add(bottom, BorderLayout.CENTER);

    }

    private JPanel buildSliderPanel() {
	JPanel o = new JPanel(new GridLayout());
	Border etch = BorderFactory.createEtchedBorder();
	o.setBorder( BorderFactory.createTitledBorder( etch, "Curve and Volume" ) );

	JPanel left = new JPanel(new BorderLayout());
	left.add(new JLabel("Curve Steps (T)", SwingConstants.CENTER), BorderLayout.NORTH);
	intervals = new JSlider(SwingConstants.VERTICAL, 5, 25, 10);
	intervals.setMajorTickSpacing(5);
	intervals.setMinorTickSpacing(1);
	intervals.setPaintTicks(true);
	intervals.setPaintLabels(true);
	intervals.addChangeListener(this);
	left.add(intervals, BorderLayout.CENTER);

	JPanel center = new JPanel(new BorderLayout());
	center.add(new JLabel("Rotation Steps (S)", SwingConstants.CENTER), BorderLayout.NORTH);
	rotsteps = new JSlider(SwingConstants.VERTICAL, 5, 15, 10);
	rotsteps.setMajorTickSpacing(5);
	rotsteps.setSnapToTicks(true);
	rotsteps.setPaintTicks(true);
	rotsteps.setPaintLabels(true);
	rotsteps.addChangeListener(this);
	center.add(rotsteps, BorderLayout.CENTER);

	
	JPanel right = new JPanel(new BorderLayout());
	right.add(new JLabel("Rotation (R)", SwingConstants.CENTER), BorderLayout.NORTH);
	rotation = new JSlider(SwingConstants.VERTICAL, 45, 360, 360);
	rotation.setMajorTickSpacing(45);
	rotation.setSnapToTicks(true);
	rotation.setPaintTicks(true);
	rotation.setPaintLabels(true);
	rotation.addChangeListener(this);
	right.add(rotation, BorderLayout.CENTER);		  

	o.add(left);
	o.add(center);
	o.add(right);

	return o;

    }


    private JPanel buildLightingPanel() {
	Hashtable labelTable;
	JPanel o = new JPanel(new BorderLayout());

	JPanel surface = new JPanel(new GridLayout());
	Border etch = BorderFactory.createEtchedBorder();
	surface.setBorder( BorderFactory.createTitledBorder( etch, "Surface" ) );

	JPanel left = new JPanel(new BorderLayout());
	left.add(new JLabel("Ka", SwingConstants.CENTER), BorderLayout.NORTH);
	ka = new JSlider(SwingConstants.VERTICAL, 0, 100, 65);
	ka.setMajorTickSpacing(25);
	ka.setMinorTickSpacing(5);
	labelTable = new Hashtable();
	labelTable.put( new Integer( 0 ), new JLabel("0") );
	labelTable.put( new Integer( 25 ), new JLabel(".25") );
	labelTable.put( new Integer( 50 ), new JLabel(".5") );
	labelTable.put( new Integer( 75 ), new JLabel(".75") );
	labelTable.put( new Integer( 100 ), new JLabel("1") );
	ka.setLabelTable(labelTable);
	ka.setPaintTicks(true);
	ka.setPaintLabels(true);
	ka.addChangeListener(this);
	left.add(ka, BorderLayout.CENTER);


	JPanel right = new JPanel(new BorderLayout());
	right.add(new JLabel("Kd", SwingConstants.CENTER), BorderLayout.NORTH);
	kd = new JSlider(SwingConstants.VERTICAL, 0, 100, 65);
	kd.setMajorTickSpacing(25);
	kd.setMinorTickSpacing(5);
	labelTable = new Hashtable();
	labelTable.put( new Integer( 0 ), new JLabel("0") );
	labelTable.put( new Integer( 25 ), new JLabel(".25") );
	labelTable.put( new Integer( 50 ), new JLabel(".5") );
	labelTable.put( new Integer( 75 ), new JLabel(".75") );
	labelTable.put( new Integer( 100 ), new JLabel("1") );
	kd.setLabelTable(labelTable);	
	kd.setPaintTicks(true);
	kd.setPaintLabels(true);
	kd.addChangeListener(this);
	right.add(kd, BorderLayout.CENTER);


	surface.add(left);
	surface.add(right);

	JPanel lights = new JPanel(new BorderLayout());
	etch = BorderFactory.createEtchedBorder();
	lights.setBorder( BorderFactory.createTitledBorder( etch, "Lights" ) );

	JPanel lp = new JPanel(new GridLayout());
	ButtonGroup lightingGroup = new ButtonGroup();
	JRadioButton lightItem;
	lightItem = new JRadioButton("Background");
	lightItem.addActionListener(this);
	lightItem.setSelected(true);
	lightingGroup.add(lightItem);  lp.add(lightItem);
	lightItem = new JRadioButton("Point");
	lightItem.addActionListener(this);
	lightingGroup.add(lightItem);  lp.add(lightItem);

	JPanel p = new JPanel(new GridLayout());

	JPanel p1 = new JPanel(new BorderLayout());
	p1.add(new JLabel("Intensity", SwingConstants.CENTER), BorderLayout.NORTH);
	intensity = new JSlider(SwingConstants.VERTICAL, 0, 100, (int)il1);
	intensity.setMajorTickSpacing(25);
	intensity.setMinorTickSpacing(5);
	labelTable = new Hashtable();
	labelTable.put( new Integer( 0 ), new JLabel("0") );
	labelTable.put( new Integer( 25 ), new JLabel(".25") );
	labelTable.put( new Integer( 50 ), new JLabel(".5") );
	labelTable.put( new Integer( 75 ), new JLabel(".75") );
	labelTable.put( new Integer( 100 ), new JLabel("1") );
	intensity.setLabelTable( labelTable );
	intensity.setPaintTicks(true);
	intensity.setPaintLabels(true);
	intensity.addChangeListener(this);
	p1.add(intensity, BorderLayout.CENTER);

	JPanel p2 = new JPanel(new BorderLayout());
	p2.add(new JLabel("x-pos", SwingConstants.CENTER), BorderLayout.NORTH);
	xslider = new JSlider(SwingConstants.VERTICAL, -25, 25, (int)xyzl1[0]);
	xslider.setMajorTickSpacing(25);
	xslider.setMinorTickSpacing(5);
	xslider.setPaintTicks(true);
	xslider.setPaintLabels(true);
	xslider.addChangeListener(this);
	p2.add(xslider, BorderLayout.CENTER);

	JPanel p3 = new JPanel(new BorderLayout());
	p3.add(new JLabel("y-pos", SwingConstants.CENTER), BorderLayout.NORTH);
	yslider = new JSlider(SwingConstants.VERTICAL, -25, 25, (int)xyzl1[1]);
	yslider.setMajorTickSpacing(25);
	yslider.setMinorTickSpacing(5);
	yslider.setPaintTicks(true);
	yslider.setPaintLabels(true);
	yslider.addChangeListener(this);
	p3.add(yslider, BorderLayout.CENTER);

	JPanel p4 = new JPanel(new BorderLayout());
	p4.add(new JLabel("z-pos", SwingConstants.CENTER), BorderLayout.NORTH);
	zslider = new JSlider(SwingConstants.VERTICAL, -25, 25, (int)xyzl1[2]);
	zslider.setMajorTickSpacing(25);
	zslider.setMinorTickSpacing(5);
	zslider.setPaintTicks(true);
	zslider.setPaintLabels(true);
	zslider.addChangeListener(this);
	p4.add(zslider, BorderLayout.CENTER);


	p.add(p1);
	p.add(p2);
	p.add(p3);
	p.add(p4);

	lights.add(lp, BorderLayout.NORTH);
	lights.add(p, BorderLayout.CENTER);


	o.add(surface, BorderLayout.WEST);
	o.add(lights, BorderLayout.EAST);

	return o;
    }


    public void actionPerformed(ActionEvent ae) {
	JRadioButton source = (JRadioButton)(ae.getSource());

	if (source.getText().equals("Background")) {
	    activelight = 1;
	    intensity.setValue((int)(il1));
	    xslider.setValue((int)xyzl1[0]);
	    yslider.setValue((int)xyzl1[1]);
	    zslider.setValue((int)xyzl1[2]);
	}
	else if (source.getText().equals("Point")) {
	    activelight = 2;
	    intensity.setValue((int)(il2));
	    xslider.setValue((int)xyzl2[0]);
	    yslider.setValue((int)xyzl2[1]);
	    zslider.setValue((int)xyzl2[2]);
	} 

    }

    public void stateChanged(ChangeEvent ce) {
	JSlider js = (JSlider)ce.getSource();

	if (js == intervals) {
	    if (!js.getValueIsAdjusting()){ // ignore drags
		double inc = js.getValue();
		inc /= 100;
		if (va.updateCurveIncrement(inc)) { }
		else { js.setValue(10); }
	    }
	}
	else if (js == rotsteps) {
	    if (!js.getValueIsAdjusting()){ // ignore drags
		if (va.updateRotationSteps(js.getValue())) { }
		else { js.setValue(10); }
	    }
	}
	else if (js == rotation) {
	    if (!js.getValueIsAdjusting()){ // ignore drags
		if (va.updateRotationAngle(js.getValue())) { }
		else { js.setValue(360); }
	    }
	}
	else if (js == intensity) {
	    if (!js.getValueIsAdjusting()){ // ignore drags
		if (activelight == 1) { 
		    il1 = (double)(js.getValue()); 
		    va.setLight(il1, xyzl1[0], xyzl1[1], xyzl1[2], 0);
		}
		else if (activelight == 2) { 
		    il2 = (double)(js.getValue()); 
		    va.setLight(il2, xyzl2[0], xyzl2[1], xyzl2[2], 1);
		}

		va.rerender();
	    }
	}
	else if (js == xslider) {
	    if (!js.getValueIsAdjusting()){ // ignore drags
		if (activelight == 1) { 
		    xyzl1[0] = (double)js.getValue(); 
		    va.setLight(il1, xyzl1[0], xyzl1[1], xyzl1[2], 0);
		}
		else if (activelight == 2) { 
		    xyzl2[0] = (double)js.getValue(); 
		    va.setLight(il2, xyzl2[0], xyzl2[1], xyzl2[2], 1);
		}

		va.rerender();
	    }
	}
	else if (js == yslider) {
	    if (!js.getValueIsAdjusting()){ // ignore drags
		if (activelight == 1) { 
		    xyzl1[1] = (double)js.getValue(); 
		    va.setLight(il1, xyzl1[0], xyzl1[1], xyzl1[2], 0);
		}
		else if (activelight == 2) { 
		    xyzl2[1] = (double)js.getValue(); 
		    va.setLight(il2, xyzl2[0], xyzl2[1], xyzl2[2], 1);
		}

		va.rerender();
	    }
	}
	else if (js == zslider) {
	    if (!js.getValueIsAdjusting()){ // ignore drags
		if (activelight == 1) { 
		    xyzl1[2] = (double)js.getValue(); 
		    va.setLight(il1, xyzl1[0], xyzl1[1], xyzl1[2], 0);
		}
		else if (activelight == 2) { 
		    xyzl2[2] = (double)js.getValue(); 
		    va.setLight(il2, xyzl2[0], xyzl2[1], xyzl2[2], 1);
		}

		va.rerender();
	    }
	}
	else if (js == ka || js == kd) {
	    if (!js.getValueIsAdjusting()){ // ignore drags
		va.setSurface((double)ka.getValue(), (double)kd.getValue());
		va.rerender();
	    }

	   
	}


    }


}
