package com.sanitysewer;

import java.awt.*;
import java.util.*;

public class Projector {
    
    private WireFrame wireframe;
    private Graphics2D g2;
    private double [][][] vessel;

    private int h, w;

    Lights lights = null;
    int lighting = Common.CONSTANT;

    private double totaldx = 0.0;  // keep track of all dx
    private double totaldy = 0.0;  // keep track of all dy

    Vector rotx;  // another annoying hack... no time to figure out why
    Vector roty;

    public Projector(Graphics2D g, WireFrame w, int height, int width, int lighting) { 
	this.g2 = g;
	this.wireframe = w;
	this.h = height; this.w = width;
	this.lighting = lighting;

	this.vessel = wireframe.getModel();

	rotx = new Vector();
	roty = new Vector();
    }

    public void setLights(Lights lt) { this.lights = lt; }

    public void setLightingMode(int m) { lighting = m; }

    public void updateWireFrame(WireFrame w) {

	// get the old rotation history
	double [][] rh = wireframe.getRotationHistory();

	// set the new wireframe
	this.wireframe = w;

// 	// update the new wireframe to the old wireframe's position
// 	wireframe.updateByMatrix(rh);
// 	wireframe.setRotationHistory(rh);
	
	// this is a hack I'd definitely like to fix
	for (int i=0; i<rotx.size(); i++) {
	    Double dX = (Double)rotx.elementAt(i); double dx = dX.doubleValue();
	    Double dY = (Double)roty.elementAt(i); double dy = dY.doubleValue();
	    wireframe.rotate(dx, dy);

	}

	// rotate needs to be called twice because, I think, 
	// of the temp variable in wireframe.rotate
// 	wireframe.rotate(0.0, totaldy);
// 	wireframe.rotate(totaldx, 0.0);
	vessel = wireframe.getModel();	
    }


    public void rotate(double dx, double dy) {
	wireframe.rotate(dx, dy);
	rotx.add(new Double(dx));
	roty.add(new Double(dy));
	vessel = wireframe.getModel();
    }

    public void render(int mode) {
	vessel = wireframe.getModel();  // ensure we have the latest copy
	
	if (mode == Common.WIREFRAME) {
	    g2.setColor(Common.PTCOLOR);
	    for (int i=0; i<vessel.length; i++) {
		for (int j=0; j<vessel[i].length; j++) {
		    if (j+1<vessel[i].length) {
			g2.drawLine((int)vessel[i][j][0], (int)vessel[i][j][1], 
				    (int)vessel[i][j+1][0], (int)vessel[i][j+1][1]);
		    }
		    if (i+1<vessel.length) {
			g2.drawLine((int)vessel[i][j][0], (int)vessel[i][j][1], 
				    (int)vessel[i+1][j][0], (int)vessel[i+1][j][1]);
		    }
		}
	    }
	}
	else if (mode == Common.POLYGONS) {
	    int len = (vessel.length-1)*(vessel[0].length-1);
	    Vector polys = new Vector(len);

	    // create an unsorted area of the polygons
	    int k=0;
	    for (int i=0; i<vessel.length-1; i++) {
		for (int j=0; j<vessel[i].length-1; j++) {


		    double [] xs = {vessel[i][j][0], vessel[i][j+1][0],
				    vessel[i+1][j+1][0], vessel[i+1][j][0]};
		    double [] ys = {vessel[i][j][1], vessel[i][j+1][1],
				    vessel[i+1][j+1][1], vessel[i+1][j][1]};
		    double [] zs = {vessel[i][j][2], vessel[i][j+1][2],
				    vessel[i+1][j+1][2], vessel[i+1][j][2]};

		    polys.add(new Polygon(xs, ys, zs));  k++;
		}
	    }

	    if (lighting == Common.GOURAUD) {
		
		int offset = vessel.length;
		double [] avg = new double[3];
		for (int i=0; i<polys.size(); i++) {
		    Polygon p = (Polygon)polys.elementAt(i);
		    Polygon pa;

		    // upper left
		    if (i - offset - 1 > 0) { avg = sumVector(avg, (i - offset - 1), polys); }
		    if (i - offset > 0) { avg = sumVector(avg, (i - offset), polys); }
		    if (i - 1 > 0) { avg = sumVector(avg, (i - 1), polys); }
		    avg[0] /= 3; avg[1] /= 3; avg[2] /= 3;
		    p.addGouraudNormal(avg);

		    // upper right
		    avg = new double[3];
		    if (i - offset > 0) { avg = sumVector(avg, (i - offset), polys); }
		    if (i - offset + 1 > 0) { avg = sumVector(avg, (i - offset + 1), polys); }
		    if (i + 1 < polys.size()) { avg = sumVector(avg, (i + 1), polys); }
		    avg[0] /= 3; avg[1] /= 3; avg[2] /= 3;
		    p.addGouraudNormal(avg);		    

		    // lower left
		    avg = new double[3];
		    if (i - 1 > 0) { avg = sumVector(avg, (i - 1), polys); }
		    if (i + offset - 1 < polys.size()) { avg = sumVector(avg, (i + offset - 1), polys); }
		    if (i + offset < polys.size()) { avg = sumVector(avg, (i + offset), polys); }
		    avg[0] /= 3; avg[1] /= 3; avg[2] /= 3;
		    p.addGouraudNormal(avg);

		    // lower right
		    if (i + 1 < polys.size()) { avg = sumVector(avg, (i + 1), polys); }
		    if (i + offset < polys.size()) { avg = sumVector(avg, (i + offset), polys); }
		    if (i + offset + 1 < polys.size()) { avg = sumVector(avg, (i + offset + 1), polys); }
		    avg[0] /= 3; avg[1] /= 3; avg[2] /= 3;
		    p.addGouraudNormal(avg);
		    }

	    }

	    // sort polygons by smallest z
	    Vector sortedpolys = polygonQsort(polys);

	    for (int i=0; i<sortedpolys.size(); i++) {
		Polygon p = (Polygon)sortedpolys.elementAt(i);


		switch(lighting) {
		case Common.CONSTANT:
		    p.paint(g2, lights);
		    break;
		case Common.GOURAUD:

 		    // if (i==0) { test(); }

		    //c = 0;
 		    Vector minipolys = dividePoly( p );
 		    //System.out.println(minipolys.size());


		    for (int j=0; j < minipolys.size(); j++) {
			Polygon mp = (Polygon)minipolys.elementAt(j);
			mp.setPlaneNormal( mp.getGouraudNormal(0) );
			mp.paint(g2, lights);
		    }

		    break;
		}


	    }
	}

    }

    private void test() {

	double [] xs = {0, 120, 120, 0};
	double [] ys = {0, 0, 120, 120};
	double [] zs = {0, 0, 0, 0};
	
	double [] n = {0, 0, 1};
	Polygon p = new Polygon(xs, ys, zs);
	p.addGouraudNormal(n);
	p.addGouraudNormal(n);
	p.addGouraudNormal(n);
	p.addGouraudNormal(n);

	Vector polys = dividePoly(p);
	int r = 0, g=0, b=0;
	
	for (int j=0; j < polys.size(); j++) {
	    Polygon mp = (Polygon)polys.elementAt(j);
	    int [] xpoints = new int[4];
	    int [] ypoints = new int[4];
	    for (int h=0; h<4; h++) {
		xpoints[h] = (int)mp.xs[h];
		ypoints[h] = (int)mp.ys[h];
	    }
	    g2.setColor(new Color(r, g, b));
	    g2.fillPolygon(xpoints, ypoints, 4);
	    r+= 10; g+=10; b+=10;
	    //	    mp.setPlaneNormal( mp.getGouraudNormal(0) );
	    //mp.paint(g2, lights);
	}

	System.out.println("Size: " + polys.size());



    }

    int c = 0;
    private Vector dividePoly(Polygon p) {
	Vector v = new Vector();

	// 	if (Math.abs(p.xs[1] - p.xs[0]) < 2 || Math.abs(p.ys[1] - p.ys[0]) < 2) {
 	//System.out.println("L: " + Math.abs(p.xs[1] - p.xs[0]));
  	// if (Math.abs(p.xs[1] - p.xs[0])*Math.abs(p.ys[1] - p.ys[0]) <= 4.0) {
	// if (Math.abs(p.xs[1] - p.xs[0]) <= 30) {

// 	c++;
// 	if (c > 4) {
	if (Math.abs(p.xs[1] - p.xs[0])*Math.abs(p.ys[1] - p.ys[0]) <= 4.0) {
	    v.add(p);
	    return v;
  	}

	// the vertex points
	double [] upperleft  = {p.xs[0], p.ys[0], p.zs[0]}; 
	double [] upperright = {p.xs[1], p.ys[1], p.zs[1]};
	double [] lowerright = {p.xs[2], p.ys[2], p.zs[2]};
	double [] lowerleft  = {p.xs[3], p.ys[3], p.zs[3]};

	double [] uppermid = get3dMid(upperright, upperleft); //System.out.println("UM: " + uppermid[0]);
	double [] lowermid = get3dMid(lowerleft, lowerright);
	double [] leftmid  = get3dMid(upperleft, lowerleft);
	double [] rightmid = get3dMid(upperright, lowerright);
	double [] mid      = get3dMid(uppermid, lowermid); 

	// each point should have an associated normal-- DON'T BE FOOLED BY THE NAME 'NORM'!!!
	double [] upperleftnorm  = p.getGouraudNormal(0);
	double [] upperrightnorm = p.getGouraudNormal(1);
	double [] lowerleftnorm  = p.getGouraudNormal(2);
	double [] lowerrightnorm = p.getGouraudNormal(3);

	double [] uppermidnorm = get3dMid(upperleftnorm, upperrightnorm);
	double [] lowermidnorm = get3dMid(lowerleftnorm, lowerrightnorm);
	double [] leftmidnorm  = get3dMid(upperleftnorm, lowerleftnorm);
	double [] rightmidnorm = get3dMid(upperrightnorm, lowerrightnorm);
	double [] midnorm      = get3dMid(uppermidnorm, lowermidnorm);

	// minipoly #1 (upperleft)
	double [] xs1 = {upperleft[0], uppermid[0], mid[0], leftmid[0]};
	double [] ys1 = {upperleft[1], uppermid[1], mid[1], leftmid[1]};
	double [] zs1 = {upperleft[2], uppermid[2], mid[2], leftmid[2]};
	Polygon p1 = new Polygon(xs1, ys1, zs1);
	p1.addGouraudNormal(upperleftnorm);
	p1.addGouraudNormal(uppermidnorm);
	p1.addGouraudNormal(midnorm);
	p1.addGouraudNormal(leftmidnorm);
	v.addAll( dividePoly(p1) );
	//System.out.println("1: " + v.size());


	// minipoly #2 (upperright)
	double [] xs2 = {uppermid[0], upperright[0], rightmid[0], mid[0]};
	double [] ys2 = {uppermid[1], upperright[1], rightmid[1], mid[1]};
	double [] zs2 = {uppermid[2], upperright[2], rightmid[2], mid[2]};
	Polygon p2 = new Polygon(xs2, ys2, zs2);
	p2.addGouraudNormal(uppermidnorm);
	p2.addGouraudNormal(upperrightnorm);
	p2.addGouraudNormal(rightmidnorm);
	p2.addGouraudNormal(midnorm);
	v.addAll( dividePoly(p2) );

	// minipoly #3 (lowerleft)
	double [] xs3 = {leftmid[0], mid[0], lowermid[0], lowerleft[0]};
	double [] ys3 = {leftmid[1], mid[1], lowermid[1], lowerleft[1]};
	double [] zs3 = {leftmid[2], mid[2], lowermid[2], lowerleft[2]};
	Polygon p3 = new Polygon(xs3, ys3, zs3);
	p3.addGouraudNormal(leftmidnorm);
	p3.addGouraudNormal(midnorm);
	p3.addGouraudNormal(lowermidnorm);
	p3.addGouraudNormal(lowerleftnorm);
	v.addAll( dividePoly(p3) );

	// minipoly #4 (lowerleft)
	double [] xs4 = {mid[0], rightmid[0], lowerright[0], lowermid[0]};
	double [] ys4 = {mid[1], rightmid[1], lowerright[1], lowermid[1]};
	double [] zs4 = {mid[2], rightmid[2], lowerright[2], lowermid[2]};
	Polygon p4 = new Polygon(xs4, ys4, zs4);
	p4.addGouraudNormal(midnorm);
	p4.addGouraudNormal(rightmidnorm);
	p4.addGouraudNormal(lowerrightnorm);
	p4.addGouraudNormal(lowermidnorm);
	v.addAll( dividePoly(p4) );

	return v;
    }

    
    private double [] get3dMid(double [] p1, double [] p2) {
	double [] pn = new double[3];

	pn[0] = (p2[0] - p1[0])/2.0 + p1[0];
	pn[1] = (p2[1] - p1[1])/2.0 + p1[1];
	pn[2] = (p2[2] - p1[2])/2.0 + p2[2];
	
	return pn;
    }

    private double [] sumVector(double [] avg, int i, Vector polys) {
	Polygon pa = (Polygon)polys.elementAt(i);
	double [] local = pa.getPlaneNormal();

	avg[0] += local[0];
	avg[1] += local[1];
	avg[2] += local[2];

	return avg;
    }


    private Vector polygonQsort(Vector liSt) {

	if (liSt.size() <= 1) { return liSt; }

	Vector left = new Vector(); 
	Vector right = new Vector(); 

	Polygon polypivot = (Polygon)liSt.elementAt(0);
	double pivot = polypivot.smallestZ;

	for (int i=1; i<liSt.size(); i++) {
	    Polygon p = (Polygon)liSt.elementAt(i);

	    if (p.smallestZ < pivot) { left.add(p); }
	    else { right.add(p); }
	}

	Vector out = new Vector(left.size() + right.size());
	out.addAll( polygonQsort(left) );
	out.add(polypivot);
	out.addAll( polygonQsort(right) );
	
	return out;
    }


}



class Polygon {
    public double [] xs, ys, zs;
    public double smallestZ;
    public double [] planenormal = new double[3];
    public Vector gouraudnormal = new Vector(3);

    public Polygon (double [] x, double [] y, double [] z) {
	this.xs = x; this.ys = y; this.zs = z;

	calcPlaneNormal();  // do this while z is still in right order

	Arrays.sort(zs);  smallestZ = zs[0];
    }


    public void calcPlaneNormal() {
	double [] p = new double[3];
	double [] q = new double[3];

	p[0] = xs[3] - xs[0];  q[0] = xs[1] - xs[0];
	p[1] = ys[3] - ys[0];  q[1] = ys[1] - ys[0];	
	p[2] = zs[3] - zs[0];  q[2] = zs[1] - zs[0];

	planenormal = Matrix.get3x3CrossProduct(p, q);
    }

    public void setPlaneNormal(double [] nm) { planenormal = nm; }

    public double [] getPlaneNormal() { return planenormal; }

    public void addGouraudNormal(double [] gxyz) { gouraudnormal.add(gxyz); }

    public double[] getGouraudNormal(int i) { return (double[])gouraudnormal.elementAt(i); }

    public void paint(Graphics2D g2, Lights lights) {

	double grey = lights.getIntensity( this.getPlaneNormal() );
	
	if (grey < 0) { grey = 0.0; } else if (grey > 1.0) { grey = 1.0; }  // safety from bad calculations
	g2.setColor( new Color((float)grey, (float)grey, (float)grey) );
	//g2.setColor( new Color((float)grey, 0, 0) );
	
	int [] xpoints = new int[4];
	int [] ypoints = new int[4];
	for (int h=0; h<4; h++) {
	    xpoints[h] = (int)this.xs[h];
	    ypoints[h] = (int)this.ys[h];
	}
	g2.fillPolygon(xpoints, ypoints, 4);
    }
}
