package com.sanitysewer;

public class Matrix {

    public Matrix() { }

 

   public static double[][]  matrixMul4x4(double [][] a, double [][] b) {

	double[][] out = new double[4][4];

	for (int i=0; i<4; i++) {
	    for (int j=0; j<4; j++) {
		out[i][j] = get4x4DotProduct(a[i], getColumnVector(b, j));
	    }
	}

	return out;
    }



    public static double[] matrix4MulVec4(double [][] matrix, double[] vec) {

	double [] out = new double[4];

	for (int i=0; i<4; i++) {
	    out[i] = get4x4DotProduct(matrix[i], vec);
	}

	return out;
    }
    
    public static double get3x3DotProduct(double[] a, double[]b) {
	return a[0]*b[0] + a[1]*b[1] + a[2]*b[2];
    }



    public static double get4x4DotProduct(double[] a, double[]b) {
	return a[0]*b[0] + a[1]*b[1] + a[2]*b[2] + a[3]*b[3];
    }



    public static double[] getColumnVector(double[][] b, int t) {
	double [] out = new double[4];
	
	for (int i=0; i<4; i++) {
	    out[i] = b[i][t];
	}

	return out;
    }


    public static double[] get3x3CrossProduct(double[] a, double[] b) {
	double [] cp = new double[3];

	cp[0] = a[1]*b[2] - a[2]*b[1];
	cp[1] = a[2]*b[0] - a[0]*b[2];
	cp[2] = a[0]*b[1] - a[1]*b[0];

	return cp;
    }


    public static double getVectorNorm(double[] a, int length) {
	double norm=0;
	
	for (int i=0; i<length; i++) { norm += Math.pow(a[i], 2); }
	norm = Math.sqrt(norm);

	return norm;
    }

    public static double [] getNormalizedVector(double [] vec) {
	double norm = getVectorNorm(vec, vec.length);

	for (int i=0; i<vec.length; i++) {
	    vec[i] = vec[i]/norm;
	}

	return vec;
    }
}
