package com.sanitysewer;

import java.util.*;

public class Lights {
    private Vector lights = new Vector(4);
    private double ka = 1, kd = 1;

    public Lights() { }

    public void addLight(double intensity, double x, double y, double z, int type) {
	intensity /= 100;  // correct scale
	lights.add( new Light(intensity, x, y, z, type) );
    }

    public void setSurface(double a, double d) {
	a /= 100;  ka = a;
	d /= 100;  kd = d;
    }

    public void setLight(double intensity, double x, double y, double z, int i) {
	intensity /= 100;  // correct scale
	Light lgt = (Light)lights.elementAt(i);
	lgt.setI(intensity);
	lgt.setX(x); lgt.setY(y); lgt.setZ(z);
    }

    public double getIntensity(double [] surfacenormal) {
	// I = Ia*ka + Ip*kd*(Nvec dot Lvec)
	
	surfacenormal = Matrix.getNormalizedVector( surfacenormal );
	//surfacenormal = getInsideOutside( surfacenormal );  // determine which face facing viewer

	double intensity = 0.0;
	for (int j=0; j<lights.size(); j++) {
	    Light light = (Light)lights.elementAt(j);
	    double [] lightnormal = Matrix.getNormalizedVector( light.getNormal() );

	    if (j == 0) {
		intensity += light.getI() * ka;
	    }
	    else {
		double dp = Matrix.get3x3DotProduct(surfacenormal, lightnormal);

		// test if this is facing light and add point light if necessary
		double alpha = dp / Matrix.getVectorNorm(surfacenormal, 3) * Matrix.getVectorNorm(lightnormal, 3);
		if (alpha >= 0) { intensity += light.getI() * kd * dp; }
	    }
	}

	return intensity;
    }

    private double [] getInsideOutside( double [] surfacenormal ) {
	double [] viewer = {0.0, 0.0, 1.0};

	double dp = Matrix.get3x3DotProduct(surfacenormal, viewer);   
	double alpha = dp / (Matrix.getVectorNorm(surfacenormal, 3) * Matrix.getVectorNorm(viewer, 3));
	if (alpha < 0) { return surfacenormal; }
	else { // rotate PI along z-axis
// 	    surfacenormal[1] = surfacenormal[0]*Math.cos(Math.PI) + surfacenormal[1] - surfacenormal[2]*Math.sin(Math.PI);
// 	    surfacenormal[2] = surfacenormal[0]*Math.sin(Math.PI) + surfacenormal[2]*Math.cos(Math.PI);
	    surfacenormal[0] *= -1;
	    surfacenormal[1] *= -1;
	    surfacenormal[2] *= -1;

	    return surfacenormal;
	}

    }

}


class Light {
    private double intensity;
    private double x, y, z;
    private int type;

    public Light(double intensity, double x, double y, double z, int type) {
	this.intensity = intensity;
	this.x = scaleup(x)*-1;  this.y = scaleup(y);  this.z = scaleup(z)*-1;
	this.type = type;
    }

    public void setI(double i) { intensity = i; }
    public void setX(double xv) { x = scaleup(xv)*-1; }
    public void setY(double yv) { y = scaleup(yv); }
    public void setZ(double zv) { z = scaleup(zv)*-1; }

    public double getI() { return intensity; }

    public double [] getNormal() {
	double [] xyz = new double[3];
	xyz[0] = x; xyz[1] = y; xyz[2] = z;

	return xyz;
    }

    private double scaleup(double x) {
	x /= 25.0;  // normalize
	x *= Common.WIDTH*4;

	return x;
    }

}
