package com.sanitysewer;

import java.awt.*;

public abstract class Curve {
    public Graphics2D g2;

    public Point start = null; 
    public Point end = null;
    public Point control1 = null;
    public Point control2 = null;
    
    public double increment = 0.1;

    public Curve(Graphics2D g) {
	this.g2 = g;
    }


//     public void setStart(int x, int y) { start = new Point(x, y); }
//     public void setEnd(int x, int y) { 	end = new Point(x, y); }
    public abstract void setStart(int x, int y);
    public abstract void setEnd(int x, int y);
    public abstract void setControl1(int x, int y);
    public abstract void setControl2(int x, int y);
    public abstract void setControlN(int x, int y);  // needed in Bspline, not in Bezier
    public abstract boolean isControl1Set();
    public abstract boolean isControl2Set();

    public void setIncrement(double di) { increment = di; }

    public boolean isStartSet() { return (start == null?false:true); }
    public boolean isEndSet() { return (end == null?false:true); }


    public abstract double[][] getDoubleArray();
    public abstract void render();
    public abstract void setDrag(Point dp, int dx, int dy);
    public abstract Point getDragPoint(int x, int y);

    public boolean closeEnough(Point p, int x, int y) {
	if (Math.abs(p.getX() - x) <= 3 &&
	    Math.abs(p.getY() - y) <= 3) { return true; }
	else {
	    return false;
	}
    }


}
