package com.sanitysewer;

import java.awt.*;
import java.util.*;

public class Bspline extends Curve {
    private Vector controlpts = new Vector(24);
    private double ax, bx, cx, dx, ay, by, cy, dy;

    private Vector values = new Vector();

    public Bspline(Graphics2D g) {
	super(g);
    }

    public void setStart(int x, int y) { 
	start = new Point(x, y); 
	controlpts.add(0, new Point(x, y));
    }
    public void setEnd(int x, int y) { 	// there's no end necessary 
	end = new Point(x, y); 
	controlpts.add(1, new Point(x, y));
    }
    public void setControl1(int x, int y){ setControlN(x, y); }
    public void setControl2(int x, int y){ setControlN(x, y); }
    public void setControlN(int x, int y){ controlpts.add(new Point(x, y)); }

    public boolean isControl1Set() { return (controlpts.isEmpty()?false:true); }
    public boolean isControl2Set() { 
	if (controlpts.size() >= 2) { return true; }
	return false;
    }

    public double[][] getDoubleArray(){ 
	render();
	double [][] out = new double[values.size()][3];

	for (int i=0; i<values.size(); i++) {
	    double [] xy = (double [])values.elementAt(i);
	    
	    out[i][0] = xy[0];
	    out[i][1] = xy[1];
	    out[i][2] = 0.0;
	}

	return out;
    }


    public void render(){ 

	g2.setColor(Common.PTCOLOR);
	if (start != null) { g2.fillRect((int)start.getX()-3, (int)start.getY()-3, 7, 7); }
	if (end != null) { g2.fillRect((int)end.getX()-3, (int)end.getY()-3, 7, 7); }

	g2.setColor(Common.CTRLCOLOR);
	if (controlpts.size() > 0) {
	    for (int i=0; i<controlpts.size(); i++) {
		Point c = (Point)controlpts.elementAt(i);
		g2.fillRect((int)c.getX()-3, (int)c.getY()-3, 7, 7); 
	    }
	}
	
	g2.setColor(Common.PTCOLOR);  // draw the curve now
	if (controlpts.size() >= 2) {
	    values = new Vector();  // don't forget to clear old values out!

	    // use control pts like a stack/heap
	    controlpts.insertElementAt(start, 0);
	    controlpts.add(end);


	    for (int i=0; i<=(controlpts.size() - 4); i++) {
		Point p1 = (Point)controlpts.elementAt(i);
		Point p2 = (Point)controlpts.elementAt(i+1);
		Point p3 = (Point)controlpts.elementAt(i+2);
		Point p4 = (Point)controlpts.elementAt(i+3);

		calcCoefficients(p1, p2, p3, p4);

		double j=0.0;
		double [] previous_xy = getBsplineXY(j);  values.add(previous_xy); 
		j += increment;
		if (i+4 == controlpts.size()) {
		    while (j <= 0.25) {
			double [] xy = getBsplineXY(j);  values.add(xy);
			g2.drawLine((int)previous_xy[0], (int)previous_xy[1], (int)xy[0], (int)xy[1]);
			previous_xy = xy;
			
			j+=increment;
			if (j > 1.0 && j < (1.0 + increment)) { j = 1.0; }  // make sure it's drawn to the end
		    }
		}
		else {
		    while (j <= 1.0) {
			double [] xy = getBsplineXY(j);  values.add(xy);
			g2.drawLine((int)previous_xy[0], (int)previous_xy[1], (int)xy[0], (int)xy[1]);
			previous_xy = xy;
			
			j+=increment;
			if (j > 1.0 && j < (1.0 + increment)) { j = 1.0; }  // make sure it's drawn to the end
		    }
		}

		
	    }


	    // return controlpts to original state!
	    controlpts.removeElementAt(0);
	    controlpts.removeElementAt(controlpts.size() - 1);

	}
    }


    public void setDrag(Point dp, int dx, int dy){ 
	dp.translate(dx, dy);
	//calcCoefficients();
    }

    public Point getDragPoint(int x, int y){  

	if (closeEnough(start, x, y)) { return start; }
	else if (closeEnough(end, x, y)) { return end; }
	
	for (int i=0; i<controlpts.size(); i++) {
	    Point p = (Point)controlpts.elementAt(i);
	    if (closeEnough(p, x, y)) { return p; }
	}

	return null;
    }


    private void calcCoefficients(Point p1, Point p2, Point p3, Point p4) {
	ax = (-1*p1.getX() + 3*p2.getX() - 3*p3.getX() + p4.getX())/6.0;
	bx = (3*p1.getX() - 6*p2.getX() + 3*p3.getX())/6.0;
	cx = (-3*p1.getX() + 3*p3.getX())/6.0;
	dx = (p1.getX() + 4*p2.getX() + 1*p3.getX())/6.0;

	ay = (-1*p1.getY() + 3*p2.getY() - 3*p3.getY() + p4.getY())/6.0;
	by = (3*p1.getY() - 6*p2.getY() + 3*p3.getY())/6.0;
	cy = (-3*p1.getY() + 3*p3.getY())/6.0;
	dy = (p1.getY() + 4*p2.getY() + 1*p3.getY())/6.0;	
    }

    private double[] getBsplineXY(double t) {
	double [] xy = new double[2];

	// x(t) = axt3 + bxt2  + cxt + x0
	xy[0] = ax * Math.pow(t, 3) + bx * Math.pow(t, 2) + cx * t + dx;

	// y(t) = ayt3 + byt2  + cyt + y
	xy[1] = ay * Math.pow(t, 3) + by * Math.pow(t, 2) + cy * t + dy;

	return xy;
    }


}
