package com.sanitysewer;

import java.awt.*;
import java.util.*;

public class Bezier extends Curve {

    private double ax, bx, cx, ay, by, cy;


    public Bezier(Graphics2D g) {
	super(g);
    }

    public void setStart(int x, int y) { start = new Point(x, y); }
    public void setEnd(int x, int y) { 	end = new Point(x, y); }
    public void setControl1(int x, int y) { control1 = new Point(x, y); }
    public void setControl2(int x, int y) { control2 = new Point(x, y); calcCoefficients(); }
    public void setControlN(int x, int y) { }

    public boolean isControl1Set() { return (control1 == null?false:true); }
    public boolean isControl2Set() { return (control2 == null?false:true); }



    public Point getDragPoint(int x, int y) {
	if (closeEnough(start, x, y)) { return start; }
	else if (closeEnough(end, x, y)) { return end; }
	else if (closeEnough(control1, x, y)) { return control1; }
	else if (closeEnough(control2, x, y)) { return control2; }
	
	return null;
    }



    public void setDrag(Point dp, int dx, int dy) {
	dp.translate(dx, dy);
	calcCoefficients();
    }



    public void render() {

	g2.setColor(Common.PTCOLOR);
	if (start != null) { g2.fillRect((int)start.getX()-3, (int)start.getY()-3, 7, 7); }
	if (end != null) { g2.fillRect((int)end.getX()-3, (int)end.getY()-3, 7, 7); }

	g2.setColor(Common.CTRLCOLOR);
	if (control1 != null) { g2.fillRect((int)control1.getX()-3, (int)control1.getY()-3, 7, 7); }
	if (control2 != null) { g2.fillRect((int)control2.getX()-3, (int)control2.getY()-3, 7, 7); }

	g2.setColor(Common.PTCOLOR);
	if (isControl2Set()) {
	    double [] previous_xy = {start.getX(), start.getY()};

	    double i=0.0;
	    while (i <= 1.0) {
		double [] xy = getBezierXY(i);
		g2.drawLine((int)previous_xy[0], (int)previous_xy[1], (int)xy[0], (int)xy[1]);
		previous_xy = xy;

		i+=increment;
		if (i > 1.0 && i < (1.0 + increment)) { i = 1.0; }  // make sure it's drawn to the end
	    }
	}
	
    }


    public double[][] getDoubleArray() {
	double [][] pts;
	Vector vec = new Vector();


	double i=0.0; int j=0;
	while (i <= 1.0) {
	    double [] xy = getBezierXY(i);
	    double [] xyz = new double[3];

	    xyz[0] = xy[0];
	    xyz[1] = xy[1];
	    xyz[2] = 0.0;
	    vec.add(xyz);
	    
	    i+=increment; j++;
	    if (i > 1.0 && i < (1.0 + increment)) { i = 1.0; }  // make sure it's drawn to the end
	}
	
	// this is a hack, damnit!  it would be nice to avoid this loop.
	pts = new double[vec.size()][3];
	for (int h=0; h<pts.length; h++) {
	    double [] xyz = (double [])vec.elementAt(h);
	    pts[h] = xyz;
	}

	return pts;
	
//  	double [][] pts = new double[(int)Math.floor(1.0/increment)+2][3];

// 	System.out.println(((int)Math.ceil(1.0/increment)+2));

// 	if (isControl2Set()) {
// 	    double [] previous_xy = {start.getX(), start.getY()};
// 	    pts[0][0] = start.getX(); pts[0][1] = start.getY(); pts[0][2] = 0.0;
// 	    double t=0.0;
// 	    int i=1;
// 	    for ( ; i<pts.length; i++, t+=increment) {
// 		double [] xy = getBezierXY(t);
// 		pts[i][0] = xy[0];  //System.out.println(xy[0] - (double)Common.WIDTH/2.0);
// 		pts[i][1] = xy[1];
// 		pts[i][2] = 0.0;
// 	    }
// 	}

// 	return pts;
    }

    private void calcCoefficients() {
	cx = 3 * (control1.getX() - start.getX());
	bx = 3 * (control2.getX() - control1.getX()) - cx;
	ax = end.getX() - start.getX() - cx - bx;

	cy = 3 * (control1.getY() - start.getY());
	by = 3 * (control2.getY() - control1.getY()) - cy;
	ay = end.getY() - start.getY() - cy - by;
    }


    private double[] getBezierXY(double t) {
	double [] xy = new double[2];

	// x(t) = axt3 + bxt2  + cxt + x0
	xy[0] = ax * Math.pow(t, 3) + bx * Math.pow(t, 2) + cx * t + start.getX();

	// y(t) = ayt3 + byt2  + cyt + y
	xy[1] = ay * Math.pow(t, 3) + by * Math.pow(t, 2) + cy * t + start.getY();

	return xy;
    }

    

}




