/* copyright University of Victoria, 2004 */

#include "logo.h"
#include "globals.h"
#include <math.h>
#include "portaudio.h"

#define NUM_SECONDS   (2)
#define SAMPLE_RATE   (44100)
#define AMPLITUDE (0.9)
#define FRAMES_PER_BUFFER  (64)
#define TONET (0)
#define HARMONYT (1)
#define STEREO_RIGHT (0)
#define STEREO_LEFT  (1)
#define TWO_PI (2 * 3.14159265359)

#define SINUSOID (0)
#define WAVEWT (1)


/* a few new types */
typedef struct 
{
  int start;
  int stop;
  float amplitude;
  struct EnvelopeData *next_envlop; /* to be used as linkedlist */
} EnvelopeData;


typedef struct
{
  float *sine;
  int left_phase;
  int right_phase;
  int table_size;    /* this is the pitch */
  int type;          /* keep track of how union is being used */
  struct OscillatorData *next_oscillator; /* to be used as linkedlist */
 
  /* These next four are used in the envelope calculation.  The first three help */
  /* identify where in the envelope (and in the linked list) the calculation is */
  /* presently located.  duration is used by tone which generates its own simple */
  /* envelope. */
  int old_stop;
  float old_amplitude;
  struct EnvelopeData *current_envelope_segment;
  union {
    int duration;                  /* duration in milliseconds */
    struct EnvelopeData *envelope; /* or a more complex envelope */
  } sustain;

} OscillatorData;


/* prototypes */
int soundCallback( void *inputBuffer, void *outputBuffer,
		   unsigned long framesPerBuffer,
		   PaTimestamp outTime, void *userData );
int harmonyCallback( void *inputBuffer, void *outputBuffer,
		   unsigned long framesPerBuffer,
		   PaTimestamp outTime, void *userData );

void playtone(OscillatorData *data, FIXNUM duration);
void playharmony(OscillatorData *first_osc, FIXNUM duration);
OscillatorData *build_harmony(NODE *args, OscillatorData *first_osc, int *d, 
			      NODE *array, int type);
void error(void);
void makeWaveTable(FIXNUM pitch, FLONUM amplitude, void *data);
void copyWaveTable(FIXNUM pitch, FLONUM amplitude, NODE *array, OscillatorData *data);
void reset_sound_globals(void);
EnvelopeData *envalloc(void);
OscillatorData *oscalloc(void);
void free_oscillators(OscillatorData *first_osc);
EnvelopeData *getEnvelopeDataLinkedList(NODE *pairs, EnvelopeData *initial_env);
float getEnvelopeFactor(void *userData);
int getDurationFromLinkedList(EnvelopeData *en);
float getSampleValueAt(int i, OscillatorData *data);



extern int SOUNDON;

/* The following are found in wave.c */

int playwaveCallback( void *inputBuffer, void *outputBuffer,
		   unsigned long framesPerBuffer,
		   PaTimestamp outTime, void *userData );
int recordwaveCallback( void *inputBuffer, void *outputBuffer,
		   unsigned long framesPerBuffer,
		   PaTimestamp outTime, void *userData );
long openforread(NODE *filenamenode);
NODE *lreversewave(NODE *args);


/* The following are found in audiofilter.c */
typedef struct {
  FLONUM a_[3];
  FLONUM b_[3];
} BiquadCoeff;

void setResonance(BiquadCoeff *bc, FLONUM frequency, FLONUM radius, int normalize); 
NODE *filter(BiquadCoeff *bc, NODE *iarray);


/* the following are found in fft.c */
NODE *fft(NODE *args, int type);
void four1(float data[], unsigned long nn, int isign);


/* the following are in audio.c */

/* This is courtesy of sun, whose .au format is used here
   in a limited, 16 bit linear, single channel fashion. A
   long type is guarateed to be at least 4 bytes... but could
   be more somewhere.
*/
typedef unsigned long u_32;  

typedef struct {
   u_32 magic;       /* magic number */
   u_32 hdr_size;    /* size of this header */
   u_32 data_size;   /* length of data (optional) */
   u_32 encoding;    /* data encoding format */
   u_32 sample_rate; /* samples per second */
   u_32 channels;    /* number of interleaved channels */
} Audio_filehdr;

void read_au_header(Audio_filehdr *au, FILE *fh);
void write_au_header(FILE *fh);
void write_little_endian_long(FILE *fh, long num);
u_32 getMagicWord(FILE *fh);
u_32 getNext_u_32Word(FILE *fh);
