#include "logo.h"
#include "globals.h"
#include "sound.h"
#include <math.h>

#define SWAP(a, b) tempr=(a); (a)=(b); (b)=tempr
#define FFT (0)
#define IFFT (1)

NODE *lfft( NODE *args ) {
  return fft(args, FFT);
}


NODE *lifft( NODE *args ) {
  return fft(args, IFFT);
}


NODE *fft(NODE *args, int type) {
  NODE *iarray, *oarray = UNBOUND;
  unsigned long n, i, j;

  iarray = car(args);
  if (nodetype(iarray) != ARRAY) { err_logo(BAD_DATA, iarray); return UNBOUND; }

  n = (unsigned long)( pow(2, ceil(log(getarrdim(iarray))/log(2))) * 2 );
  float *data = (float *)malloc(sizeof(float)*n);

  for (i=0, j=0; i<getarrdim(iarray); i++, j+=2) {
    data[j]   = getfloat((getarrptr(iarray))[i]); /* real part */
    data[j+1] = 0;                                /* imaginary part */
  }

  if (type == FFT) { four1( data-1, n/2, 1); }
  else if (type == IFFT) { four1( data-1, n/2, -1); }


  /* move the real part of the results  back into a LOGO array */
  oarray = make_array(getarrdim(iarray));
  setarrorg(oarray, 0);

  for (i=0, j=0; i<getarrdim(iarray) && j<n; i++, j+=2) {
    (getarrptr(oarray))[i] = newnode(FLOATT);

    if (type == FFT) { setfloat(getarrptr(oarray)[i], data[j]); }
    else if (type == IFFT) { setfloat(getarrptr(oarray)[i], (data[j])/getarrdim(iarray)); }
  }

  free(data);

  return oarray;
}


/* This is taken almost straight out of Numerical Recipes (chap 12.2)... */
/* and my understanding of this fft algorithm is tenuous even at that! */
void four1(float data[], unsigned long nn, int isign) {

  unsigned long n, mmax, m, j, istep, i;
  double wtemp, wr, wpr, wpi, wi, theta;
  float tempr, tempi;

  n = nn << 1;
  j = 1;
  for (i=1; i<n; i+=2) {
    if (j > i) {
      SWAP(data[j], data[i]);
      SWAP(data[j+1],data[i+1]);
    }
    m = nn;
    while (m >= 2 && j > m) {
      j -= m;
      m >>= 1;
    }
    j += m;
  }

  mmax=2;
  while (n > mmax) {
    istep = mmax << 1;
    theta = isign * (6.28318530717959/mmax);
    wtemp = sin(0.5 * theta);
    wpr = -2.0 * wtemp * wtemp;

    wpi = sin( theta );
    wr = 1.0;
    wi = 0.0;
    for (m=1; m<mmax; m+=2) {
      for (i=m; i<=n; i+=istep) {
	j = i+mmax;
	tempr = wr * data[j] - wi * data[j+1];
	tempi = wr * data[j+1] + wi * data[j];
	data[j] = data[i] - tempr;
	data[j+1] = data[i+1] - tempi;
	data[i] += tempr;
	data[i+1] += tempi;
      }
      wr = (wtemp=wr) * wpr - wi * wpi + wr;
      wi = wi * wpr + wtemp * wpi + wi;
    }
    mmax = istep;
  }
}

