#include "sound.h"


/* arguments are array, frequency, radius */
NODE *lfilterwave(NODE *args) 
{
  NODE *array, *f, *w;
  FLONUM freq, width;
  
  if (nodetype(car(args)) != ARRAY){ err_logo(BAD_DATA, car(args)); return UNBOUND; }
  else { array = car(args); }

  f = numeric_arg(cdr(args));
  w = numeric_arg(cddr(args));

  if (NOT_THROWING) {
    freq = (nodetype(f) == FLOATT) ? getfloat(f) : (FLONUM)getint(f);
    width = (nodetype(w) == FLOATT) ? getfloat(w) : (FLONUM)getint(w);
    if (freq < 0 || width < 0) { return UNBOUND; }
  }
  else { return UNBOUND; }

  BiquadCoeff *bc;
  setResonance(bc, freq, width, TRUE);
  NODE *oarray = filter( bc, array );

  return( oarray );
}


/* from Perry Cook's STK */
void setResonance(BiquadCoeff *bc, FLONUM frequency, FLONUM radius, int normalize) 
{

  bc->a_[1] = radius * radius;
  bc->a_[0] = -2.0 * radius * cos(TWO_PI * frequency / SAMPLE_RATE);

  if ( normalize == TRUE ) {
    // Use zeros at +- 1 and normalize the filter peak gain.
    bc->b_[0] = 0.5 - 0.5 * bc->a_[2];
    bc->b_[1] = 0.0;
    bc->b_[2] = -bc->b_[0];
  }
}

/* also from Perry Cook's STK */
NODE *filter(BiquadCoeff *bc, NODE *iarray)
{
  NODE *oarray;

  oarray = make_array( getarrdim(iarray) );
  setarrorg(oarray, 0);


  FLONUM output0 = 1.0;
  FLONUM output1 = 1.0;
  FLONUM output2 = 1.0;
  FLONUM input0 = 1.0;
  FLONUM input1 = 1.0;
  FLONUM input2 = 1.0;

  long i=0;
  for (; i<getarrdim(iarray)-3; i++) {
    input0 = getfloat((getarrptr(iarray))[i]);
    output0 = bc->b_[0] * input0 + bc->b_[1] * input1 + bc->b_[2] * input2;
    output0 -= bc->a_[2] * output2 + bc->a_[1] * output1;
    input2 = input1;
    input1 = input0;
    output2 = output1;
    output1 = output0;

    (getarrptr(oarray))[i] = newnode(FLOATT); 
    (getarrptr(oarray))[i+1] = newnode(FLOATT);
    (getarrptr(oarray))[i+2] = newnode(FLOATT);

    setfloat( (getarrptr(oarray))[i], output0 ); 
    setfloat( (getarrptr(oarray))[i+1], output1 );
    setfloat( (getarrptr(oarray))[i+2], output2 );

  }

  return oarray;
} 
