/* copyright University of Victoria, 2004 */

#ifdef unix
#include "pthread.h"
#endif

#include "sound.h"

void ptest(int bob);

void ptest(int bob) {
  printf("bob %d\n", bob);

/*   int i; */
/*   for (i=0; i<500; i++) { */
/*     printf("A%d ", i); */
/*     Pa_Sleep(100); */
/*   } */

}

NODE *lthread(NODE *args) {
  pthread_t thread;

#ifndef unix
  return lrun(args);
#endif


/*   lrun(args); */
/*   return ; */


  int t = pthread_create( &thread, NULL, lrun, args);
  return t;


  /* int t = pthread_create( &thread, NULL, &ptest, 4); */

/*   int i; */
/*   for (i=0; i<500; i++) { */
/*     printf("B%d ", i); */
/*     Pa_Sleep(100); */
/*   } */


/*   pthread_exit(NULL); */
/*   printf("%d\n", t); */




/*   int t = pthread_create( &thread, NULL, ptest,  NULL); */
/*   return lrun(args); */
/*   return UNBOUND; */
/*   return arg; */
}


NODE *lwriteaudio(NODE *args){ 
  NODE *filenamenode, *array;

  /* using procedures from files.c */
  filenamenode = car(args);  args = cdr(args);

  
  if (nodetype(filenamenode) == ARRAY){ err_logo(BAD_DATA, filenamenode); return UNBOUND; }

  lopen(filenamenode, "w");
  write_au_header((FILE *)file_list->n_obj);

  array = car(args);
  if (nodetype(array) != ARRAY){ err_logo(BAD_DATA, array); return UNBOUND; }

  unsigned long i=0, j=0;
  for (; i<getarrdim(array); i++){
    short sample = 0x0000;
    sample = (short)(getfloat((getarrptr(array))[i]) * (0xffff/2.0f) );
 
    /* make 2's compliment */
    sample = ~(sample) + 1;

    /* .au audio data is big endian all the time */
    fputc((sample & 0xff00) >> 8, (FILE *)file_list->n_obj);
    fputc((sample & 0x00ff), (FILE *)file_list->n_obj);    
  }

  lclose(filenamenode);

  return UNBOUND; 
}

void write_au_header(FILE *fh) {
  fprintf(fh, ".snd");
  
  write_little_endian_long(fh, (long)24); /* header size */
  write_little_endian_long(fh, (long)-1); /* not using data length */
  write_little_endian_long(fh, (long)3);  /* 16 bit PCM, 2's compliment */
  write_little_endian_long(fh, (long)44100); /* sample rate */
  write_little_endian_long(fh, (long)1);  /* channels, always mono */


}

void write_little_endian_long(FILE *fh, long num) {
  fputc((num & 0xff000000) >> 24, fh);
  fputc((num & 0x00ff0000) >> 16, fh);
  fputc((num & 0x0000ff00) >> 8, fh);
  fputc((num & 0x000000ff), fh);
}


/* NODE *lwriteaudio(NODE *args){  */
/*   NODE *filenamenode, *array; */

/*   /\* using procedures from files.c *\/ */
/*   filenamenode = car(args);  args = cdr(args); */
/*   lopen(filenamenode, "w"); */

/*   array = car(args); */
/*   if (nodetype(array) != ARRAY){ err_logo(BAD_DATA, array); return UNBOUND; } */

/*   unsigned long i=0, j=0; */
/*   for (; i<getarrdim(array); i++){ */
/*     float sample = 0.0; */
/*     sample = getfloat((getarrptr(array))[i]); */

/*     float buffer[1024]; */
/*     if (j < 1024 && i != (getarrdim(array) -1)){ buffer[j] = sample; j+=1; } */
/*     else { */
/*       if (fwrite(buffer, sizeof(float), j, (FILE *)file_list->n_obj) < j){ */
/* 	err_logo(BAD_DATA_UNREC, car(args)); */
/*       } */

/*       j = 0; /\* reset to fill next buffer *\/ */
/*     } */

/*   } */
  

/*   lclose(filenamenode); */

/*   return UNBOUND;  */
/* } */


/* This will read .au files... and will even read them correctly
   if the file is mono or stereo, linear 16 bit, 44.1kHz. Use 
   sox otherwise. */

/*  here's a cute check for the endianess... just keeping it track here */
/*       /\* check endianess *\/ */
/*       short s = 0x0102; */
/*       char *p = (char *) &s; */
/*       if (p[0] == 0x02) // Lowest address contains the least significant byte */
/* 	/\* little-endian, requires adjustment *\/ */
NODE *lreadaudio(NODE *args) { 
  NODE *filenamenode, *array;
  Audio_filehdr *au = (Audio_filehdr *)malloc( sizeof(Audio_filehdr) );

  /* using procedures from files.c */
  filenamenode = car(args);  args = cdr(args);

  long length = (long)(openforread(filenamenode));
  array = make_array(length);
  setarrorg(array, 0);

  read_au_header(au, (FILE *)file_list->n_obj);

  /* warn about possible file problems, but don't bail */
  if (au->magic != 0x2e736e64 || au->encoding != 3 || au->channels > 2) {
    printf("File may be of the wrong format.  Suggestion: convert
            to 16bit PCM .au (mono or stereo) format with a program such as sox\n");
  }

  /* let's skip the .au header */
  if ((fseek((FILE *)file_list->n_obj, au->hdr_size, SEEK_SET)) == -1) {
    return UNBOUND;
  }

  /* load the array of FLOATTs */
  char buffer[4096];
  long i=0;
  int c = 0;
  float stereo_sample = 0.0f;
  while (!feof((FILE *)file_list->n_obj) && !ferror((FILE *)file_list->n_obj)){
    int num = fread(buffer, sizeof(char), 4096, (FILE *)file_list->n_obj);
    long j=0;
    for (; j<num; j+=2){
      short t1 = 0x0000;
      short t2 = 0x0000;
      if (buffer[j] >> 7 == 1){ t1 = buffer[j] & 0xffff; }
      else { t1 = buffer[j] & 0x00ff;  }
      if (buffer[j+1] >> 7 == 1){ t2 = buffer[j] & 0xffff; }
      else { t2 = buffer[j] & 0x00ff;  }
      signed short x = t1|t2;

#ifndef mac
      x = ( x >> 8 ) | ( x << 8 );
#endif
      x = ~(x-1);
      
      if (i < length) {
	if (au->channels == 1) {
	  (getarrptr(array))[i] = newnode(FLOATT);
	  setfloat( (getarrptr(array))[i], (float)(x)/(0xffff/2.0f) );
	  i+=1;
	}
	else {
	  stereo_sample += (float)(x)/(0xffff/2.0f);  c+=1;
	  if (c == 2) {
	    (getarrptr(array))[i] = newnode(FLOATT);
	    setfloat( (getarrptr(array))[i], stereo_sample/2 );
	    stereo_sample = 0.0f;
	    c = 0;
	    i+=1;
	  }
	}
      }
    }
  }


  lclose(filenamenode);

  free(au);

  return array; 
}


u_32 getMagicWord(FILE *fh) {
  u_32 u = 0;
  char buffer[4];
  int num = fread(buffer, sizeof(char), 4, fh);
  if (num != 4) { return 0; }
  
  u |= buffer[0] & 0xffffffff;  u <<= 8;
  u |= buffer[1] & 0xffffffff;  u <<= 8;
  u |= buffer[2] & 0xffffffff;  u <<= 8;
  u |= buffer[3] & 0xffffffff;

  return u;
}

u_32 getNext_u_32Word(FILE *fh) {
  u_32 u = 0x00000000;
  u = getMagicWord(fh);

  /* i'm not sure this byte swap is really necessary, needs
     testing on the appropriate platform */
#ifdef mac
  u = (u >> 24) | (u >> 8) | (u << 8) | (u << 24);
#endif

  return u;
}

void read_au_header(Audio_filehdr *au, FILE *fh) {
  au->magic = getMagicWord(fh);
  au->hdr_size = getNext_u_32Word(fh);    /* size of this header */
  au->data_size = getNext_u_32Word(fh);   /* length of data (optional) */
  au->encoding = getNext_u_32Word(fh);    /* data encoding format */
  au->sample_rate = getNext_u_32Word(fh); /* samples per second */
  au->channels = getNext_u_32Word(fh);    /* number of interleaved channels */
}


long openforread(NODE *filenamenode){
  FILE *tmp;


  /* using procedures from files.c */

  /* this, unfortunately, is a repeat of the code in lopen, but it was necessary to
     remove a level of indirection to get at filehand directly and test if the file
     already exists. */
  if (find_file(filenamenode, FALSE) != NULL){
    err_logo(FILE_ERROR, make_static_strnode(message_texts[ALREADY_OPEN]));
    return(-1);
  }
  else if ((tmp = open_file(filenamenode, "r")) != NULL) {
    push(filenamenode, file_list);
    file_list->n_obj = (NODE *)tmp;
  }
  else {
    err_logo(FILE_ERROR, make_static_strnode(message_texts[CANT_OPEN]));
    return(-1);
  }

  /* create the appropriate size array */
  fseek((FILE *)file_list->n_obj, 0, SEEK_END);
  long length = ftell((FILE *)file_list->n_obj);
  fseek((FILE *)file_list->n_obj, SEEK_SET, SEEK_SET);

  return length;

}
